/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.framework.config.module.ModuleConfigurer;
import org.kuali.rice.core.framework.config.module.WebModuleConfiguration;
import org.kuali.rice.core.framework.lifecycle.ServiceDelegatingLifecycle;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.messaging.AlternateEndpoint;
import org.kuali.rice.ksb.messaging.AlternateEndpointLocation;
import org.kuali.rice.ksb.messaging.MessageFetcher;
import org.kuali.rice.ksb.messaging.resourceloader.KSBResourceLoaderFactory;
import org.kuali.rice.ksb.messaging.serviceconnectors.HttpInvokerConnector;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.quartz.Scheduler;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.transaction.PlatformTransactionManager;

public class KSBConfigurer
extends ModuleConfigurer
implements SmartApplicationListener {
    private static final String SERVICE_BUS_CLIENT_SPRING = "classpath:org/kuali/rice/ksb/config/KsbServiceBusClientSpringBeans.xml";
    private static final String MESSAGE_CLIENT_SPRING = "classpath:org/kuali/rice/ksb/config/KsbMessageClientSpringBeans.xml";
    private static final String OJB_MESSAGE_CLIENT_SPRING = "classpath:org/kuali/rice/ksb/config/KsbOjbMessageClientSpringBeans.xml";
    private static final String BAM_SPRING = "classpath:org/kuali/rice/ksb/config/KsbBamSpringBeans.xml";
    private static final String OJB_BAM_SPRING = "classpath:org/kuali/rice/ksb/config/KsbOjbBamSpringBeans.xml";
    private static final String REGISTRY_SERVER_SPRING = "classpath:org/kuali/rice/ksb/config/KsbRegistryServerSpringBeans.xml";
    private static final String OJB_REGISTRY_SPRING = "classpath:org/kuali/rice/ksb/config/KsbOjbRegistrySpringBeans.xml";
    private static final String WEB_SPRING = "classpath:org/kuali/rice/ksb/config/KsbWebSpringBeans.xml";
    private List<ServiceDefinition> services = new ArrayList<ServiceDefinition>();
    private List<AlternateEndpointLocation> alternateEndpointLocations = new ArrayList<AlternateEndpointLocation>();
    private List<AlternateEndpoint> alternateEndpoints = new ArrayList<AlternateEndpoint>();
    private DataSource registryDataSource;
    private DataSource messageDataSource;
    private DataSource nonTransactionalMessageDataSource;
    private DataSource bamDataSource;
    private Scheduler exceptionMessagingScheduler;
    private PlatformTransactionManager platformTransactionManager;
    private List<Lifecycle> internalLifecycles;

    public KSBConfigurer() {
        super("ksb");
        this.setValidRunModes(Arrays.asList(RunMode.THIN, RunMode.REMOTE, RunMode.LOCAL));
        this.internalLifecycles = new ArrayList<Lifecycle>();
    }

    public void addAdditonalToConfig() {
        this.configureDataSource();
        this.configureScheduler();
        this.configurePlatformTransactionManager();
        this.configureAlternateEndpoints();
    }

    public List<String> getPrimarySpringFiles() {
        ArrayList<String> springFileLocations = new ArrayList<String>();
        springFileLocations.add(SERVICE_BUS_CLIENT_SPRING);
        if (this.getRunMode() != RunMode.THIN) {
            boolean isJpa = OrmUtils.isJpaEnabled((String)"rice.ksb");
            if (isJpa) {
                throw new UnsupportedOperationException("JPA not currently supported for KSB");
            }
            springFileLocations.add(MESSAGE_CLIENT_SPRING);
            springFileLocations.add(OJB_MESSAGE_CLIENT_SPRING);
            if (this.isBamEnabled()) {
                springFileLocations.add(BAM_SPRING);
                springFileLocations.add(OJB_BAM_SPRING);
            }
        }
        if (this.getRunMode().equals((Object)RunMode.LOCAL)) {
            springFileLocations.add(REGISTRY_SERVER_SPRING);
            springFileLocations.add(OJB_REGISTRY_SPRING);
        }
        return springFileLocations;
    }

    public boolean hasWebInterface() {
        return true;
    }

    public boolean shouldRenderWebInterface() {
        if (ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.ksb.web.forceEnable").booleanValue()) {
            return true;
        }
        return super.shouldRenderWebInterface();
    }

    protected WebModuleConfiguration loadWebModule() {
        WebModuleConfiguration configuration = super.loadWebModule();
        configuration.getWebSpringFiles().add(WEB_SPRING);
        return configuration;
    }

    public Collection<ResourceLoader> getResourceLoadersToRegister() throws Exception {
        ResourceLoader ksbRemoteResourceLoader = KSBResourceLoaderFactory.createRootKSBRemoteResourceLoader();
        ksbRemoteResourceLoader.start();
        return Collections.singletonList(ksbRemoteResourceLoader);
    }

    public List<Lifecycle> loadLifecycles() throws Exception {
        LinkedList<Lifecycle> lifecycles = new LinkedList<Lifecycle>();
        lifecycles.add((Lifecycle)new BaseLifecycle(){

            public void start() throws Exception {
                if (Boolean.valueOf(ConfigContext.getCurrentContextConfig().getProperty("rice.ksb.config.allowSelfSignedSSL")).booleanValue()) {
                    Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443));
                }
                super.start();
            }
        });
        return lifecycles;
    }

    protected void validateServices(List<ServiceDefinition> services) {
        for (ServiceDefinition serviceDef : this.services) {
            serviceDef.validate();
        }
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof ContextRefreshedEvent) {
            this.doAdditionalContextStartedLogic();
        } else if (applicationEvent instanceof ContextStoppedEvent) {
            this.doAdditionalContextStoppedLogic();
        }
    }

    protected void doAdditionalContextStartedLogic() {
        this.validateServices(this.getServices());
        ServicePublisher servicePublisher = new ServicePublisher(this.getServices());
        ServiceDelegatingLifecycle serviceBus = new ServiceDelegatingLifecycle("rice.ksb.serviceBus");
        ServiceDelegatingLifecycle threadPool = new ServiceDelegatingLifecycle("rice.ksb.threadPool");
        ServiceDelegatingLifecycle scheduledThreadPool = new ServiceDelegatingLifecycle("rice.ksb.scheduledThreadPool");
        try {
            servicePublisher.start();
            this.internalLifecycles.add((Lifecycle)servicePublisher);
            serviceBus.start();
            this.internalLifecycles.add((Lifecycle)serviceBus);
            threadPool.start();
            this.internalLifecycles.add((Lifecycle)threadPool);
            scheduledThreadPool.start();
            this.internalLifecycles.add((Lifecycle)scheduledThreadPool);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RiceRuntimeException("Failed to initialize KSB on context startup");
        }
        if (this.getRunMode() != RunMode.THIN) {
            this.requeueMessages();
        }
    }

    protected void doAdditionalContextStoppedLogic() {
        try {
            HttpInvokerConnector.shutdownIdleConnectionTimeout();
        }
        catch (Exception e) {
            this.LOG.error((Object)"Failed to shutdown idle connection timeout evictor thread.", (Throwable)e);
        }
        this.cleanUpConfiguration();
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> aClass) {
        return true;
    }

    public boolean supportsSourceType(Class<?> aClass) {
        return true;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    protected void doAdditionalModuleStartLogic() throws Exception {
        this.LOG.info((Object)"Synchronizing remote services with service bus after KSB startup...");
        long startTime = System.currentTimeMillis();
        KsbApiServiceLocator.getServiceBus().synchronizeRemoteServices();
        long endTime = System.currentTimeMillis();
        this.LOG.info((Object)("...total time to synchronize remote services with service bus after KSB startup: " + (endTime - startTime)));
    }

    protected void doAdditionalModuleStopLogic() throws Exception {
        for (int index = this.internalLifecycles.size() - 1; index >= 0; --index) {
            try {
                this.internalLifecycles.get(index).stop();
                continue;
            }
            catch (Exception e) {
                this.LOG.error((Object)"Failed to properly execute shutdown logic.", (Throwable)e);
            }
        }
    }

    private void requeueMessages() {
        this.LOG.info((Object)"Refreshing Service Registry to export services to the bus.");
        KsbApiServiceLocator.getServiceBus().synchronizeLocalServices();
        MessageFetcher messageFetcher = new MessageFetcher((Integer)null);
        KSBServiceLocator.getThreadPool().execute(messageFetcher);
    }

    protected boolean isMessagePersistenceEnabled() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("message.persistence", true);
    }

    protected boolean isBamEnabled() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("bam.enabled", false);
    }

    protected void configureScheduler() {
        if (this.getExceptionMessagingScheduler() != null) {
            this.LOG.info((Object)"Configuring injected exception messaging Scheduler");
            ConfigContext.getCurrentContextConfig().putObject("message.injected.scheduler", (Object)this.getExceptionMessagingScheduler());
        }
    }

    protected void configureDataSource() {
        if (this.isMessagePersistenceEnabled()) {
            if (this.getMessageDataSource() != null) {
                ConfigContext.getCurrentContextConfig().putObject("rice.ksb.message.datasource", (Object)this.getMessageDataSource());
            }
            if (this.getNonTransactionalMessageDataSource() != null) {
                ConfigContext.getCurrentContextConfig().putObject("rice.ksb.message.nonTransactional.datasource", (Object)this.getNonTransactionalMessageDataSource());
            }
        }
        if (this.getRunMode().equals((Object)RunMode.LOCAL) && this.getRegistryDataSource() != null) {
            ConfigContext.getCurrentContextConfig().putObject("rice.ksb.registry.datasource", (Object)this.getRegistryDataSource());
        }
        if (this.isBamEnabled() && this.getBamDataSource() != null) {
            ConfigContext.getCurrentContextConfig().putObject("rice.ksb.bam.datasource", (Object)this.getBamDataSource());
        }
    }

    protected void configurePlatformTransactionManager() {
        if (this.getPlatformTransactionManager() == null) {
            return;
        }
        ConfigContext.getCurrentContextConfig().putObject("SPRING_TRANSACTION_MANAGER", (Object)this.getPlatformTransactionManager());
    }

    protected void configureAlternateEndpoints() {
        ConfigContext.getCurrentContextConfig().putObject("ksb.alternateEndpointLocations", this.getAlternateEndpointLocations());
        ConfigContext.getCurrentContextConfig().putObject("ksb.alternateEndpoints", this.getAlternateEndpoints());
    }

    protected void cleanUpConfiguration() {
        ConfigContext.getCurrentContextConfig().removeObject("ksb.alternateEndpoints");
    }

    public List<ServiceDefinition> getServices() {
        return this.services;
    }

    public void setServices(List<ServiceDefinition> javaServices) {
        this.services = javaServices;
    }

    public DataSource getMessageDataSource() {
        return this.messageDataSource;
    }

    public void setMessageDataSource(DataSource messageDataSource) {
        this.messageDataSource = messageDataSource;
    }

    public DataSource getNonTransactionalMessageDataSource() {
        return this.nonTransactionalMessageDataSource;
    }

    public void setNonTransactionalMessageDataSource(DataSource nonTransactionalMessageDataSource) {
        this.nonTransactionalMessageDataSource = nonTransactionalMessageDataSource;
    }

    public DataSource getRegistryDataSource() {
        return this.registryDataSource;
    }

    public void setRegistryDataSource(DataSource registryDataSource) {
        this.registryDataSource = registryDataSource;
    }

    public DataSource getBamDataSource() {
        return this.bamDataSource;
    }

    public void setBamDataSource(DataSource bamDataSource) {
        this.bamDataSource = bamDataSource;
    }

    public Scheduler getExceptionMessagingScheduler() {
        return this.exceptionMessagingScheduler;
    }

    public void setExceptionMessagingScheduler(Scheduler exceptionMessagingScheduler) {
        this.exceptionMessagingScheduler = exceptionMessagingScheduler;
    }

    public PlatformTransactionManager getPlatformTransactionManager() {
        return this.platformTransactionManager;
    }

    public void setPlatformTransactionManager(PlatformTransactionManager springTransactionManager) {
        this.platformTransactionManager = springTransactionManager;
    }

    public List<AlternateEndpointLocation> getAlternateEndpointLocations() {
        return this.alternateEndpointLocations;
    }

    public void setAlternateEndpointLocations(List<AlternateEndpointLocation> alternateEndpointLocations) {
        this.alternateEndpointLocations = alternateEndpointLocations;
    }

    public List<AlternateEndpoint> getAlternateEndpoints() {
        return this.alternateEndpoints;
    }

    public void setAlternateEndpoints(List<AlternateEndpoint> alternateEndpoints) {
        this.alternateEndpoints = alternateEndpoints;
    }

    private final class ServicePublisher
    extends BaseLifecycle {
        private final List<ServiceDefinition> serviceDefinitions;

        ServicePublisher(List<ServiceDefinition> serviceDefinitions) {
            this.serviceDefinitions = serviceDefinitions;
        }

        public void start() throws Exception {
            if (this.serviceDefinitions != null && !this.serviceDefinitions.isEmpty()) {
                KSBConfigurer.this.LOG.debug((Object)("Configuring " + this.serviceDefinitions.size() + " services for application id " + CoreConfigHelper.getApplicationId() + " using config for classloader " + ClassLoaderUtils.getDefaultClassLoader()));
                KsbApiServiceLocator.getServiceBus().publishServices(this.serviceDefinitions, true);
                super.start();
            }
        }
    }
}

