/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.quartz;

import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.messaging.quartz.MessageServiceExecutorJobListener;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

public class KSBSchedulerFactoryBean
extends SchedulerFactoryBean {
    private PlatformTransactionManager jtaTransactionManager;
    private TransactionManager transactionManager;
    private DataSource dataSource;
    private DataSource nonTransactionalDataSource;
    private boolean transactionManagerSet = false;
    private boolean nonTransactionalDataSourceSet = false;
    private boolean nonTransactionalDataSourceNull = true;
    private boolean dataSourceSet = false;
    private boolean schedulerInjected = false;

    protected Scheduler createScheduler(SchedulerFactory schedulerFactory, String schedulerName) throws SchedulerException {
        if (ConfigContext.getCurrentContextConfig().getObject("message.injected.scheduler") != null) {
            try {
                this.schedulerInjected = true;
                Scheduler scheduler = (Scheduler)ConfigContext.getCurrentContextConfig().getObject("message.injected.scheduler");
                scheduler.addJobListener((JobListener)new MessageServiceExecutorJobListener());
                return scheduler;
            }
            catch (Exception e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
        return super.createScheduler(schedulerFactory, schedulerName);
    }

    public void afterPropertiesSet() throws Exception {
        boolean useQuartzDatabase = new Boolean(ConfigContext.getCurrentContextConfig().getProperty("useQuartzDatabase"));
        if (useQuartzDatabase && !this.schedulerInjected) {
            if (this.jtaTransactionManager == null) {
                throw new ConfigurationException("No jta transaction manager was configured for the KSB Quartz Scheduler");
            }
            this.setTransactionManager(this.jtaTransactionManager);
            if (!this.nonTransactionalDataSourceSet) {
                this.nonTransactionalDataSource = KSBServiceLocator.getMessageNonTransactionalDataSource();
                if (this.nonTransactionalDataSource == null) {
                    throw new ConfigurationException("No non-transactional data source was found but is required for the KSB Quartz Scheduler");
                }
                super.setNonTransactionalDataSource(this.nonTransactionalDataSource);
            }
            if (!this.dataSourceSet) {
                this.dataSource = KSBServiceLocator.getMessageDataSource();
            }
            super.setDataSource(this.dataSource);
            if (this.transactionManagerSet && this.nonTransactionalDataSourceNull) {
                throw new ConfigurationException("A valid transaction manager was set but no non-transactional data source was found");
            }
        }
        super.afterPropertiesSet();
    }

    public void setTransactionManager(PlatformTransactionManager jtaTransactionManager) {
        this.transactionManagerSet = jtaTransactionManager != null;
        this.jtaTransactionManager = jtaTransactionManager;
    }

    public void setNonTransactionalDataSource(DataSource nonTransactionalDataSource) {
        this.nonTransactionalDataSourceSet = true;
        this.nonTransactionalDataSourceNull = nonTransactionalDataSource == null;
        this.nonTransactionalDataSource = nonTransactionalDataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSourceSet = true;
        this.dataSource = dataSource;
    }
}

