/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceexporters;

import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.api.bus.support.RestServiceDefinition;
import org.kuali.rice.ksb.messaging.serviceexporters.AbstractWebServiceExporter;
import org.kuali.rice.ksb.messaging.serviceexporters.ServiceExporter;

public class RESTServiceExporter
extends AbstractWebServiceExporter
implements ServiceExporter {
    private static final Logger LOG = Logger.getLogger(RESTServiceExporter.class);

    public RESTServiceExporter(RestServiceDefinition serviceDefinition, Bus cxfBus) {
        super((ServiceDefinition)serviceDefinition, cxfBus);
    }

    @Override
    public void publishService(ServiceDefinition serviceDefinition, Object serviceImpl, String address) {
        RestServiceDefinition restServiceDef = (RestServiceDefinition)serviceDefinition;
        LOG.info((Object)("Creating JAXRSService " + restServiceDef.getServiceName()));
        JAXRSServerFactoryBean svrFactory = new JAXRSServerFactoryBean();
        svrFactory.setBus(this.getCXFBus());
        List resources = restServiceDef.getResources();
        if (resources != null && !resources.isEmpty()) {
            svrFactory.setServiceBeans(resources);
        } else {
            try {
                Class<?> resourceClass = this.getClass().getClassLoader().loadClass(restServiceDef.getResourceClass());
                svrFactory.setResourceClasses(new Class[]{resourceClass});
                svrFactory.setResourceProvider(resourceClass, (ResourceProvider)new SingletonResourceProvider(serviceImpl));
            }
            catch (ClassNotFoundException e) {
                throw new RiceRuntimeException("Failed to publish the service because resource class could not be loaded: " + restServiceDef.getResourceClass(), (Throwable)e);
            }
        }
        svrFactory.setServiceName(restServiceDef.getServiceName());
        svrFactory.setAddress(address);
        svrFactory.setExtensionMappings(restServiceDef.getExtensionMappings());
        svrFactory.setLanguageMappings(restServiceDef.getLanguageMappings());
        List providers = restServiceDef.getProviders();
        if (providers != null) {
            svrFactory.setProviders(providers);
        }
        BindingFactoryManager bindingFactoryManager = (BindingFactoryManager)this.getCXFBus().getExtension(BindingFactoryManager.class);
        JAXRSBindingFactory bindingFactory = new JAXRSBindingFactory();
        bindingFactory.setBus(this.getCXFBus());
        bindingFactoryManager.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", (BindingFactory)bindingFactory);
        if (LOG.isDebugEnabled()) {
            svrFactory.getInInterceptors().add(new LoggingInInterceptor());
        }
        if (LOG.isDebugEnabled()) {
            svrFactory.getOutInterceptors().add(new LoggingOutInterceptor());
        }
        svrFactory.setPublishedEndpointUrl(restServiceDef.getEndpointUrl().toExternalForm());
        svrFactory.create();
    }
}

