/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.collections.EnumerationUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.servicelist.ServiceListGeneratorServlet;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.SoapServiceConfiguration;
import org.kuali.rice.ksb.messaging.servlet.CXFServletControllerAdapter;
import org.kuali.rice.ksb.messaging.servlet.KSBHttpInvokerHandler;
import org.kuali.rice.ksb.security.SignatureSigningResponseWrapper;
import org.kuali.rice.ksb.security.SignatureVerifyingRequestWrapper;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.springframework.beans.BeansException;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import org.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;

public class KSBDispatcherServlet
extends DispatcherServlet {
    private static final Logger LOG = Logger.getLogger(KSBDispatcherServlet.class);
    private static final long serialVersionUID = 6790121225857950019L;
    private static final String REMOTING_SERVLET_CONFIG_LOCATION = "classpath:org/kuali/rice/ksb/config/remoting-servlet.xml";
    private KSBHttpInvokerHandler httpInvokerHandler;
    private ServletController cxfServletController;

    protected void initFrameworkServlet() throws ServletException, BeansException {
        HTTPTransportFactory transportFactory;
        List<Interceptor<? extends Message>> outInterceptors;
        this.httpInvokerHandler = new KSBHttpInvokerHandler();
        Bus bus = KSBServiceLocator.getCXFBus();
        List<Interceptor<? extends Message>> inInterceptors = KSBServiceLocator.getInInterceptors();
        if (inInterceptors != null) {
            List busInInterceptors = bus.getInInterceptors();
            busInInterceptors.addAll(inInterceptors);
        }
        if ((outInterceptors = KSBServiceLocator.getOutInterceptors()) != null) {
            List busOutInterceptors = bus.getOutInterceptors();
            busOutInterceptors.addAll(outInterceptors);
        }
        if ((transportFactory = (HTTPTransportFactory)bus.getExtension(HTTPTransportFactory.class)) == null) {
            throw new IllegalStateException("Failed to locate HTTPTransportFactory extension on Apache CXF Bus");
        }
        DestinationRegistry destinationRegistry = transportFactory.getRegistry();
        this.cxfServletController = new ServletController(destinationRegistry, this.getCXFServletConfig(this.getServletConfig()), (HttpServlet)new ServiceListGeneratorServlet(destinationRegistry, bus));
        this.setPublishEvents(false);
    }

    protected ServletConfig getCXFServletConfig(final ServletConfig baseServletConfig) {
        final String shouldHide = Boolean.toString(ConfigContext.getCurrentContextConfig().getDevMode() == false);
        return new ServletConfig(){
            private static final String HIDE_SERVICE_LIST_PAGE_PARAM = "hide-service-list-page";

            public String getServletName() {
                return baseServletConfig.getServletName();
            }

            public ServletContext getServletContext() {
                return baseServletConfig.getServletContext();
            }

            public String getInitParameter(String parameter) {
                if (HIDE_SERVICE_LIST_PAGE_PARAM.equals(parameter)) {
                    return shouldHide;
                }
                return baseServletConfig.getInitParameter(parameter);
            }

            public Enumeration<String> getInitParameterNames() {
                List initParameterNames = EnumerationUtils.toList((Enumeration)baseServletConfig.getInitParameterNames());
                initParameterNames.add(HIDE_SERVICE_LIST_PAGE_PARAM);
                return new Vector(initParameterNames).elements();
            }
        };
    }

    protected HandlerAdapter getHandlerAdapter(Object handler) throws ServletException {
        if (handler instanceof HttpRequestHandler) {
            return new HttpRequestHandlerAdapter();
        }
        if (handler instanceof Controller) {
            Object unwrappedHandler = ClassLoaderUtils.unwrapFromProxy((Object)handler);
            if (unwrappedHandler instanceof CXFServletControllerAdapter) {
                ((CXFServletControllerAdapter)unwrappedHandler).setController(this.cxfServletController);
            }
            return new SimpleControllerHandlerAdapter();
        }
        throw new RiceRuntimeException("handler of type " + handler.getClass().getName() + " is not known and can't be used by " + KSBDispatcherServlet.class.getName());
    }

    protected HandlerExecutionChain getHandler(HttpServletRequest request, boolean cache) throws Exception {
        return this.httpInvokerHandler.getHandler(request);
    }

    protected ModelAndView processHandlerException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        try {
            QName serviceName = this.httpInvokerHandler.getServiceNameFromRequest(request);
            LOG.info((Object)("Caught Exception from service " + serviceName), (Throwable)ex);
        }
        catch (Throwable throwable) {
            LOG.warn((Object)"Caught exception attempting to log exception thrown from remotely accessed service", throwable);
        }
        return null;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isSecure(request)) {
            super.service((HttpServletRequest)new SignatureVerifyingRequestWrapper(request), (HttpServletResponse)new SignatureSigningResponseWrapper(response));
        } else {
            super.service(request, response);
        }
    }

    protected WebApplicationContext initWebApplicationContext() {
        this.setContextConfigLocation(REMOTING_SERVLET_CONFIG_LOCATION);
        return super.initWebApplicationContext();
    }

    protected boolean isSecure(HttpServletRequest request) {
        Endpoint endpoint;
        QName serviceName = this.httpInvokerHandler.getServiceNameFromRequest(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking service " + serviceName + " for security enabled"));
        }
        if ((endpoint = KsbApiServiceLocator.getServiceBus().getEndpoint(serviceName)) == null) {
            LOG.error((Object)("Attempting to acquire non-existent service " + request.getRequestURI()));
            throw new RiceRuntimeException("Attempting to acquire non-existent service.");
        }
        ServiceConfiguration serviceConfiguration = endpoint.getServiceConfiguration();
        if (serviceConfiguration instanceof SoapServiceConfiguration) {
            return false;
        }
        return serviceConfiguration.getBusSecurity();
    }
}

