/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security.httpinvoker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.kuali.rice.core.api.security.credentials.CredentialsSource;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.messaging.KSBHttpInvokerRequestExecutor;
import org.kuali.rice.ksb.security.credentials.UsernamePasswordCredentials;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.util.Assert;

public final class AuthenticationCommonsHttpInvokerRequestExecutor
extends KSBHttpInvokerRequestExecutor {
    private final CredentialsSource credentialsSource;
    private final ServiceConfiguration serviceConfiguration;

    public AuthenticationCommonsHttpInvokerRequestExecutor(HttpClient httpClient, CredentialsSource credentialsSource, ServiceConfiguration serviceConfiguration) {
        super(httpClient);
        Assert.notNull((Object)credentialsSource, (String)"credentialsSource cannot be null.");
        Assert.notNull((Object)serviceConfiguration, (String)"serviceConfiguration cannot be null.");
        this.credentialsSource = credentialsSource;
        this.serviceConfiguration = serviceConfiguration;
    }

    @Override
    protected void setRequestBody(HttpInvokerClientConfiguration config, PostMethod postMethod, ByteArrayOutputStream baos) throws IOException {
        UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)this.credentialsSource.getCredentials(this.serviceConfiguration.getEndpointUrl().toExternalForm());
        String base64 = credentials.getUsername() + ":" + credentials.getPassword();
        postMethod.addRequestHeader("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])base64.getBytes())));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("HttpInvocation now presenting via BASIC authentication CredentialsSource-derived: " + credentials.getUsername()));
        }
        super.setRequestBody(config, postMethod, baos);
    }
}

