/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security.soap;

import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.kuali.rice.core.api.security.credentials.Credentials;
import org.kuali.rice.core.api.security.credentials.CredentialsSource;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.security.credentials.UsernamePasswordCredentials;
import org.springframework.util.Assert;

public class CredentialsOutHandler
extends WSS4JOutInterceptor {
    private final CredentialsSource credentialsSource;
    private final ServiceConfiguration serviceConfiguration;

    public CredentialsOutHandler(CredentialsSource credentialsSource, ServiceConfiguration serviceConfiguration) {
        Assert.notNull((Object)credentialsSource, (String)"credentialsSource cannot be null.");
        Assert.notNull((Object)serviceConfiguration, (String)"serviceConfiguration cannot be null.");
        this.credentialsSource = credentialsSource;
        this.serviceConfiguration = serviceConfiguration;
        Credentials credentials = this.credentialsSource.getCredentials(this.serviceConfiguration.getEndpointUrl().toString());
        Assert.isTrue((boolean)(credentials instanceof UsernamePasswordCredentials), (String)"Credentials must be of type usernamepassword.");
        UsernamePasswordCredentials c = (UsernamePasswordCredentials)credentials;
        this.setProperty("user", c.getUsername());
    }

    public WSPasswordCallback getPassword(String username, int doAction, String clsProp, String refProp, RequestData reqData) throws WSSecurityException {
        UsernamePasswordCredentials c = (UsernamePasswordCredentials)this.credentialsSource.getCredentials(this.serviceConfiguration.getEndpointUrl().toString());
        return new WSPasswordCallback(c.getUsername(), c.getPassword(), null, 2);
    }
}

