/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceexporters;

import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.log4j.Logger;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.messaging.bam.BAMServerProxy;
import org.kuali.rice.ksb.messaging.serviceexporters.ServiceExporter;
import org.kuali.rice.ksb.messaging.servlet.CXFServletControllerAdapter;

public abstract class AbstractWebServiceExporter
implements ServiceExporter {
    static final Logger LOG = Logger.getLogger(AbstractWebServiceExporter.class);
    private final ServiceDefinition serviceDefinition;
    private final Bus cxfBus;

    protected abstract void publishService(ServiceDefinition var1, Object var2, String var3) throws Exception;

    public AbstractWebServiceExporter(ServiceDefinition serviceDefinition, Bus cxfBus) {
        this.serviceDefinition = serviceDefinition;
        this.cxfBus = cxfBus;
    }

    @Override
    public Object exportService(ServiceDefinition serviceDefinition) {
        try {
            String serviceAddress = this.getServiceAddress(serviceDefinition);
            if (!this.isServicePublished(serviceAddress)) {
                this.publishService(serviceDefinition, serviceDefinition.getService(), serviceAddress);
            }
            CXFServletControllerAdapter cxfController = new CXFServletControllerAdapter();
            return BAMServerProxy.wrap(cxfController, serviceDefinition);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getServiceAddress(ServiceDefinition serviceDefinition) {
        String serviceAddress = serviceDefinition.getServicePath();
        serviceAddress = "/".equals(serviceAddress) ? serviceAddress + serviceDefinition.getServiceName().getLocalPart() : serviceAddress + "/" + serviceDefinition.getServiceName().getLocalPart();
        return serviceAddress;
    }

    protected boolean isServicePublished(String serviceAddress) {
        ServerRegistry serverRegistry = this.getCXFServerRegistry();
        List servers = serverRegistry.getServers();
        for (Server server : servers) {
            String endpointAddress = server.getEndpoint().getEndpointInfo().getAddress();
            if (!endpointAddress.contains(serviceAddress)) continue;
            LOG.info((Object)("Service already published on CXF, not republishing: " + serviceAddress));
            return true;
        }
        return false;
    }

    protected ServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    protected Bus getCXFBus() {
        return this.cxfBus;
    }

    protected ServerRegistry getCXFServerRegistry() {
        return (ServerRegistry)this.getCXFBus().getExtension(ServerRegistry.class);
    }
}

