/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.threadpool;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.messaging.threadpool.KSBScheduledPool;

public class KSBScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor
implements KSBScheduledPool {
    private static final Logger LOG = Logger.getLogger(KSBScheduledThreadPoolExecutor.class);
    private boolean started;
    private static final int DEFAULT_SIZE = 2;

    public KSBScheduledThreadPoolExecutor() {
        super(2, new KSBThreadFactory());
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() throws Exception {
        LOG.info((Object)"Starting the KSB scheduled thread pool...");
        try {
            Integer size = new Integer(ConfigContext.getCurrentContextConfig().getProperty("ksb.fixedPoolSize"));
            this.setCorePoolSize(size);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        LOG.info((Object)"...KSB scheduled thread pool successfully started.");
    }

    public void stop() throws Exception {
        LOG.info((Object)"Stopping the KSB scheduled thread pool...");
        try {
            int pendingTasks = this.shutdownNow().size();
            LOG.info((Object)(pendingTasks + " pending tasks..."));
            LOG.info((Object)("awaiting termination: " + this.awaitTermination(20L, TimeUnit.SECONDS)));
            LOG.info((Object)("...KSB scheduled thread pool successfully stopped, isShutdown=" + this.isShutdown() + ", isTerminated=" + this.isTerminated()));
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception thrown shutting down " + KSBScheduledThreadPoolExecutor.class.getSimpleName()), (Throwable)e);
        }
    }

    private static class KSBThreadFactory
    implements ThreadFactory {
        private ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

        private KSBThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.defaultThreadFactory.newThread(runnable);
            thread.setName("KSB-Scheduled-" + thread.getName());
            return thread;
        }
    }
}

