/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.bam;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.ContextClassLoaderProxy;
import org.kuali.rice.core.api.util.reflect.BaseTargetedInvocationHandler;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.messaging.bam.BAMTargetEntry;
import org.kuali.rice.ksb.service.KSBServiceLocator;

public class BAMServerProxy
extends BaseTargetedInvocationHandler<Object> {
    private ServiceDefinition serviceDefinition;

    private BAMServerProxy(Object target, ServiceDefinition serviceDefinition) {
        super(target);
        this.serviceDefinition = serviceDefinition;
    }

    public static boolean isBamSupported() {
        return KSBServiceLocator.getBAMService() != null && Boolean.valueOf(ConfigContext.getCurrentContextConfig().getProperty("bam.enabled")) != false;
    }

    public static Object wrap(Object target, ServiceDefinition serviceDefinition) {
        if (!BAMServerProxy.isBamSupported()) {
            return target;
        }
        return Proxy.newProxyInstance(target.getClass().getClassLoader(), ContextClassLoaderProxy.getInterfacesToProxy((Object)target), (InvocationHandler)((Object)new BAMServerProxy(target, serviceDefinition)));
    }

    protected Object invokeInternal(Object proxiedObject, Method method, Object[] arguments) throws Throwable {
        BAMTargetEntry bamTargetEntry = KSBServiceLocator.getBAMService().recordServerInvocation(this.getTarget(), this.serviceDefinition, method, arguments);
        try {
            return method.invoke(this.getTarget(), arguments);
        }
        catch (Throwable throwable) {
            if (throwable instanceof InvocationTargetException) {
                throwable = throwable.getCause();
            }
            KSBServiceLocator.getBAMService().recordServerInvocationError(throwable, bamTargetEntry);
            throw throwable;
        }
    }
}

