/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceexporters;

import java.net.URI;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.ServerRegistry;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.messaging.serviceexporters.ServiceExportManager;
import org.kuali.rice.ksb.messaging.serviceexporters.ServiceExporter;
import org.kuali.rice.ksb.messaging.serviceexporters.ServiceExporterFactory;

public class ServiceExportManagerImpl
implements ServiceExportManager {
    private final ConcurrentMap<QName, ExportedServiceHolder> exportedServices = new ConcurrentHashMap<QName, ExportedServiceHolder>();
    private final ServiceNameFinder serviceNameFinder = new ServiceNameFinder();
    private Bus cxfBus;

    @Override
    public QName getServiceName(String endpointUrl) {
        return this.getServiceNameFinder().lookup(endpointUrl);
    }

    protected ServiceNameFinder getServiceNameFinder() {
        return this.serviceNameFinder;
    }

    @Override
    public Object getService(QName serviceName) {
        ExportedServiceHolder holder = (ExportedServiceHolder)this.exportedServices.get(serviceName);
        if (holder == null) {
            return null;
        }
        return holder.getExportedService();
    }

    @Override
    public void exportService(ServiceDefinition serviceDefinition) {
        if (serviceDefinition == null) {
            throw new IllegalArgumentException("serviceDefinition was null");
        }
        ServiceExporter serviceExporter = ServiceExporterFactory.getServiceExporter(serviceDefinition, this.cxfBus);
        Object exportedService = serviceExporter.exportService(serviceDefinition);
        this.exportedServices.put(serviceDefinition.getServiceName(), new ExportedServiceHolder(exportedService, serviceDefinition));
        this.getServiceNameFinder().register(serviceDefinition);
    }

    @Override
    public void removeService(QName serviceName) {
        ExportedServiceHolder exportedServiceHolder = (ExportedServiceHolder)this.exportedServices.remove(serviceName);
        this.getServiceNameFinder().remove(exportedServiceHolder.getServiceDefinition().getEndpointUrl());
    }

    protected ConcurrentMap<QName, ExportedServiceHolder> getExportedServices() {
        return this.exportedServices;
    }

    public void setCxfBus(Bus cxfBus) {
        this.cxfBus = cxfBus;
    }

    @Deprecated
    public void setCxfServerRegistry(ServerRegistry cxfServerRegistry) {
    }

    protected static class ServiceNameFinder {
        private ConcurrentMap<String, QName> servicePathToQName = new ConcurrentHashMap<String, QName>();

        protected ServiceNameFinder() {
        }

        private String trimServiceUrlBase(String url) {
            String trimmedUrl = StringUtils.removeStart((String)url, (String)ConfigContext.getCurrentContextConfig().getEndPointUrl());
            if (trimmedUrl.length() == url.length()) {
                URI serviceUri = URI.create(url);
                URI endpointUrlBase = URI.create(ConfigContext.getCurrentContextConfig().getEndPointUrl());
                String reqPath = serviceUri.getPath();
                String basePath = endpointUrlBase.getPath();
                trimmedUrl = StringUtils.removeStart((String)reqPath, (String)basePath);
            }
            return trimmedUrl;
        }

        public void register(ServiceDefinition serviceDefinition) {
            String serviceUrlBase = this.trimServiceUrlBase(serviceDefinition.getEndpointUrl().toExternalForm());
            if (serviceUrlBase.endsWith("/")) {
                serviceUrlBase = StringUtils.chop((String)serviceUrlBase);
            }
            this.servicePathToQName.put(serviceUrlBase, serviceDefinition.getServiceName());
        }

        public void remove(URL endpointUrl) {
            this.servicePathToQName.remove(this.trimServiceUrlBase(endpointUrl.toExternalForm()));
        }

        public QName lookup(String serviceUrl) {
            String serviceUrlBase = this.trimServiceUrlBase(serviceUrl);
            if (serviceUrlBase.length() > 0 && serviceUrlBase.lastIndexOf(63) != -1) {
                serviceUrlBase = serviceUrlBase.substring(0, serviceUrlBase.lastIndexOf(63));
            }
            QName qname = null;
            while (qname == null) {
                qname = (QName)this.servicePathToQName.get(serviceUrlBase);
                int lastSeparatorIndex = serviceUrlBase.lastIndexOf(47);
                if (lastSeparatorIndex == -1) break;
                serviceUrlBase = serviceUrlBase.substring(0, lastSeparatorIndex);
            }
            return qname;
        }
    }

    protected static class ExportedServiceHolder {
        private final Object exportedService;
        private final ServiceDefinition serviceDefinition;

        ExportedServiceHolder(Object exportedService, ServiceDefinition serviceDefinition) {
            this.exportedService = exportedService;
            this.serviceDefinition = serviceDefinition;
        }

        public Object getExportedService() {
            return this.exportedService;
        }

        public ServiceDefinition getServiceDefinition() {
            return this.serviceDefinition;
        }
    }
}

