/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Signature;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

public class SignatureVerifyingInputStream
extends ServletInputStream {
    private final byte[] digitalSignature;
    private final Signature signature;
    private final InputStream wrappedInputStream;
    private boolean finished = false;

    public SignatureVerifyingInputStream(byte[] digitalSignature, Signature signature, InputStream wrappedInputStream) {
        this.digitalSignature = digitalSignature;
        this.signature = signature;
        this.wrappedInputStream = wrappedInputStream;
    }

    public synchronized int read() throws IOException {
        int data = this.wrappedInputStream.read();
        try {
            if (data == -1) {
                this.finished = true;
                this.verifySignature();
            } else {
                this.signature.update((byte)data);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error processing digital signature.", e);
        }
        return data;
    }

    protected void verifySignature() throws IOException, GeneralSecurityException {
        boolean verifies = this.signature.verify(this.digitalSignature);
        if (!verifies) {
            throw new IOException("The digital signature could not be successfully verified!");
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isReady() {
        return true;
    }

    public void setReadListener(ReadListener readListener) {
        throw new UnsupportedOperationException();
    }
}

