/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.ksb.service.BasicAuthenticationConnectionCredentials;
import org.kuali.rice.ksb.service.BasicAuthenticationCredentials;
import org.kuali.rice.ksb.service.BasicAuthenticationService;

public class BasicAuthenticationServiceImpl
implements BasicAuthenticationService {
    private Map<QName, List<BasicAuthenticationCredentials>> serviceCredentialsMap = Collections.synchronizedMap(new HashMap());
    private Map<QName, BasicAuthenticationConnectionCredentials> connectionCredentialsMap = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkServiceAuthentication(String serviceNameSpaceURI, QName serviceName, String username, String password) {
        List<BasicAuthenticationCredentials> credentialsList = this.serviceCredentialsMap.get(serviceName);
        if (credentialsList != null) {
            List<BasicAuthenticationCredentials> list = credentialsList;
            synchronized (list) {
                for (BasicAuthenticationCredentials credentials : credentialsList) {
                    if (!StringUtils.equals((String)username, (String)credentials.getUsername()) || !StringUtils.equals((String)serviceNameSpaceURI, (String)credentials.getServiceNameSpaceURI())) continue;
                    return StringUtils.equals((String)password, (String)credentials.getPassword());
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPasswordForService(String serviceNameSpaceURI, QName serviceName, String username) {
        List<BasicAuthenticationCredentials> credentialsList = this.serviceCredentialsMap.get(serviceName);
        if (credentialsList != null) {
            List<BasicAuthenticationCredentials> list = credentialsList;
            synchronized (list) {
                for (BasicAuthenticationCredentials credentials : credentialsList) {
                    if (!StringUtils.equals((String)username, (String)credentials.getUsername()) || !StringUtils.equals((String)serviceNameSpaceURI, (String)credentials.getServiceNameSpaceURI())) continue;
                    return credentials.getPassword();
                }
            }
        }
        return null;
    }

    @Override
    public BasicAuthenticationConnectionCredentials getConnectionCredentials(String serviceNameSpaceURI, String serviceName) {
        return this.connectionCredentialsMap.get(new QName(serviceNameSpaceURI, serviceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerServiceCredentials(BasicAuthenticationCredentials credentials) {
        Map<QName, List<BasicAuthenticationCredentials>> map = this.serviceCredentialsMap;
        synchronized (map) {
            QName serviceName = new QName(credentials.getServiceNameSpaceURI(), credentials.getLocalServiceName());
            List<BasicAuthenticationCredentials> credentialsList = this.serviceCredentialsMap.get(serviceName);
            if (credentialsList == null) {
                credentialsList = Collections.synchronizedList(new ArrayList());
                this.serviceCredentialsMap.put(serviceName, credentialsList);
            }
            credentialsList.add(credentials);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnectionCredentials(BasicAuthenticationConnectionCredentials credentials) {
        Map<QName, BasicAuthenticationConnectionCredentials> map = this.connectionCredentialsMap;
        synchronized (map) {
            this.connectionCredentialsMap.put(new QName(credentials.getServiceNameSpaceURI(), credentials.getLocalServiceName()), credentials);
        }
    }
}

