/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.impl.bus;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.ServiceBusAdminService;
/**
 * Reference implementation of the {@link org.kuali.rice.ksb.api.bus.ServiceBusAdminService}
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class ServiceBusAdminServiceImpl implements ServiceBusAdminService {

    @Override
    public void clearServiceBusCache()
            throws RiceIllegalArgumentException {

        KsbApiServiceLocator.getServiceBus().synchronize();
    }
}
