/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.impl.bus.diff;

/**
 * A complete difference between local and remote KSB services.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class CompleteServiceDiff {

	private final LocalServicesDiff localServicesDiff;
	private final RemoteServicesDiff remoteServicesDiff;
	
	public CompleteServiceDiff(LocalServicesDiff localServicesDiff, RemoteServicesDiff remoteServicesDiff) {
		if (localServicesDiff == null) {
			throw new IllegalArgumentException("localServicesDiff cannot be null");
		}
		if (remoteServicesDiff == null) {
			throw new IllegalArgumentException("remoteServicesDiff cannot be null");
		}
		this.localServicesDiff = localServicesDiff;
		this.remoteServicesDiff = remoteServicesDiff;
	}

	public LocalServicesDiff getLocalServicesDiff() {
		return this.localServicesDiff;
	}

	public RemoteServicesDiff getRemoteServicesDiff() {
		return this.remoteServicesDiff;
	}
	
}
