/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.service.impl;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.dao.MessageQueueDAO;
import org.kuali.rice.ksb.messaging.service.MessageQueueService;
import org.kuali.rice.ksb.util.KSBConstants;

import java.util.List;
import java.util.Map;

public class MessageQueueServiceImpl implements MessageQueueService {

    private static final Logger LOG = LogManager.getLogger(MessageQueueServiceImpl.class);

    private MessageQueueDAO messageQueueDao;

    @Override
    public void delete(PersistedMessageBO routeQueue) {
        if (Boolean.parseBoolean(ConfigContext.getCurrentContextConfig().getProperty(KSBConstants.Config.MESSAGE_PERSISTENCE))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Message Persistence is on.  Deleting stored message" + routeQueue);
            }
            this.getMessageQueueDao().remove(routeQueue);
        }
    }

    @Override
    public PersistedMessageBO save(PersistedMessageBO routeQueue) {
        if (Boolean.parseBoolean(ConfigContext.getCurrentContextConfig().getProperty(KSBConstants.Config.MESSAGE_PERSISTENCE))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Persisting Message " + routeQueue);
            }
            return getMessageQueueDao().save(routeQueue);
        }
        return routeQueue;
    }

    @Override
    public List<PersistedMessageBO> findAll(int maxRows) {
        return this.getMessageQueueDao().findAll(maxRows);
    }

    @Override
    public PersistedMessageBO findByRouteQueueId(Long routeQueueId) {
        return getMessageQueueDao().findByRouteQueueId(routeQueueId);
    }

    @Override
    public List<PersistedMessageBO> getNextDocuments(Integer maxDocuments) {
        return this.getMessageQueueDao().getNextDocuments(maxDocuments);
    }

    public MessageQueueDAO getMessageQueueDao() {
        return this.messageQueueDao;
    }

    public void setMessageQueueDao(MessageQueueDAO queueDAO) {
        this.messageQueueDao = queueDAO;
    }

    @Override
    public List<PersistedMessageBO> findByValues(Map<String, String> criteriaValues, int maxRows) {
        return getMessageQueueDao().findByValues(criteriaValues, maxRows);
    }

}
