/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.serviceconnectors;

import org.kuali.rice.core.api.security.credentials.CredentialsSource;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface ServiceConnector {
	
	Object getService();
	
	/**
	 * Method to set the optional CredentialsSource. A ServiceConnector is free
	 * to use the CredentialsSource to provide credentials to a remote service.

	 */
	void setCredentialsSource(CredentialsSource credentialsSource);

}
