/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceconnectors;

import java.net.URL;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.JavaServiceConfiguration;
import org.kuali.rice.ksb.messaging.KSBHttpInvokerProxyFactoryBean;
import org.kuali.rice.ksb.messaging.KSBHttpInvokerRequestExecutor;
import org.kuali.rice.ksb.messaging.serviceconnectors.AbstractServiceConnector;
import org.kuali.rice.ksb.messaging.serviceconnectors.HttpClientConfigurer;
import org.kuali.rice.ksb.security.httpinvoker.AuthenticationCommonsHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;

public class HttpInvokerConnector
extends AbstractServiceConnector {
    private static final Logger LOG = LogManager.getLogger(HttpInvokerConnector.class);
    private static final String HTTP_CLIENT_CONFIG_BEAN = "rice.ksb.httpClientConfigurer";

    public HttpInvokerConnector(JavaServiceConfiguration serviceConfiguration, URL alternateEndpointUrl) {
        super((ServiceConfiguration)serviceConfiguration, alternateEndpointUrl);
    }

    public JavaServiceConfiguration getServiceConfiguration() {
        return (JavaServiceConfiguration)super.getServiceConfiguration();
    }

    @Override
    public Object getService() {
        LOG.debug("Getting connector for endpoint " + String.valueOf(this.getActualEndpointUrl()));
        KSBHttpInvokerProxyFactoryBean client = new KSBHttpInvokerProxyFactoryBean();
        client.setServiceUrl(this.getActualEndpointUrl().toExternalForm());
        client.setServiceConfiguration(this.getServiceConfiguration());
        KSBHttpInvokerRequestExecutor executor = this.getCredentialsSource() != null ? new AuthenticationCommonsHttpInvokerRequestExecutor(this.getHttpClient(), this.getCredentialsSource(), (ServiceConfiguration)this.getServiceConfiguration()) : new KSBHttpInvokerRequestExecutor(this.getHttpClient());
        executor.setSecure(this.getServiceConfiguration().getBusSecurity());
        client.setHttpInvokerRequestExecutor((HttpInvokerRequestExecutor)executor);
        client.afterPropertiesSet();
        return this.getServiceProxyWithFailureMode(client.getObject(), (ServiceConfiguration)this.getServiceConfiguration());
    }

    public HttpClient getHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        HttpInvokerConnector.getHttpClientConfigurer().customizeHttpClient(httpClientBuilder);
        return httpClientBuilder.build();
    }

    private static HttpClientConfigurer getHttpClientConfigurer() {
        return HttpClientConfigurerHolder.httpClientConfigurer;
    }

    private static class HttpClientConfigurerHolder {
        static final HttpClientConfigurer httpClientConfigurer = (HttpClientConfigurer)GlobalResourceLoader.getService((String)"rice.ksb.httpClientConfigurer");

        private HttpClientConfigurerHolder() {
        }
    }
}

