/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security.admin;

import java.io.Serializable;
import java.security.KeyStore;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class KeyStoreEntryDataContainer
implements Serializable {
    private static final String DISPLAYABLE_ENTRY_TYPE_TRUSTED_CERTIFICATE = "Trusted Certificate";
    private static final String DISPLAYABLE_ENTRY_TYPE_PRIVATE_KEY = "Private Key";
    private static final String DISPLAYABLE_ENTRY_TYPE_SECRET_KEY = "Secret Key";
    public static final Map<Class<? extends KeyStore.Entry>, String> DISPLAYABLE_ENTRY_TYPES = new HashMap<Class<? extends KeyStore.Entry>, String>();
    private String alias;
    private Date createDate;
    private Class<? extends KeyStore.Entry> type;

    public KeyStoreEntryDataContainer(String alias, Date createDate) {
        this.alias = alias;
        this.createDate = createDate;
    }

    public boolean isAllowsRemoval() {
        return KeyStore.TrustedCertificateEntry.class.equals(this.type);
    }

    public String getDisplayType() {
        return DISPLAYABLE_ENTRY_TYPES.get(this.getType());
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Class<? extends KeyStore.Entry> getType() {
        return this.type;
    }

    public void setType(Class<? extends KeyStore.Entry> type) {
        this.type = type;
    }

    static {
        DISPLAYABLE_ENTRY_TYPES.put(KeyStore.TrustedCertificateEntry.class, DISPLAYABLE_ENTRY_TYPE_TRUSTED_CERTIFICATE);
        DISPLAYABLE_ENTRY_TYPES.put(KeyStore.PrivateKeyEntry.class, DISPLAYABLE_ENTRY_TYPE_PRIVATE_KEY);
        DISPLAYABLE_ENTRY_TYPES.put(KeyStore.SecretKeyEntry.class, DISPLAYABLE_ENTRY_TYPE_SECRET_KEY);
    }
}

