/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.security.service.impl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.ksb.security.admin.service.JavaSecurityManagementService;
import org.kuali.rice.ksb.security.service.DigitalSignatureService;
import org.kuali.rice.ksb.util.KSBConstants;

public class DigitalSignatureServiceImpl implements DigitalSignatureService {

	@Override
    public Signature getSignatureForSigning() throws IOException, GeneralSecurityException {
		Signature signature = getSignature();
		signature.initSign(getJavaSecurityManagementService().getModulePrivateKey());
		return signature;
	}

    @Override
    public Signature getSignatureForVerification(String verificationAlias) throws IOException, GeneralSecurityException {
        Certificate cert = getJavaSecurityManagementService().getCertificate(verificationAlias);
        return getSignatureForVerification(cert);
    }

    @Override
    public Signature getSignatureForVerification(Certificate certificate) throws IOException, GeneralSecurityException {
        if (certificate == null) {
            throw new CertificateException("Could not find certificate");
        }
        PublicKey publicKey = certificate.getPublicKey();
        if (publicKey == null) {
            throw new KeyException("Could not find the public key from valid certificate");
        }
        Signature signature = getSignature();
        signature.initVerify(publicKey);
        return signature;
    }
    
	protected Signature getSignature() throws GeneralSecurityException {
		return Signature.getInstance(getJavaSecurityManagementService().getModuleSignatureAlgorithm());
	}
	
	protected JavaSecurityManagementService getJavaSecurityManagementService() {
		return (JavaSecurityManagementService)GlobalResourceLoader.getService(KSBConstants.ServiceNames.JAVA_SECURITY_MANAGEMENT_SERVICE);
	}


}
