/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.impl.registry;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Version;
import javax.xml.namespace.QName;
import org.kuali.rice.ksb.api.registry.ServiceEndpointStatus;
import org.kuali.rice.ksb.api.registry.ServiceInfo;
import org.kuali.rice.ksb.api.registry.ServiceInfoContract;

public class ServiceInfoBo
implements ServiceInfoContract,
Serializable {
    private static final long serialVersionUID = -4244884858494208070L;
    @Column(name="SVC_DEF_ID")
    private String serviceId;
    @Column(name="SVC_NM")
    private String serviceName;
    @Column(name="SVC_URL", length=500)
    private String endpointUrl;
    @Column(name="INSTN_ID")
    private String instanceId;
    @Column(name="APPL_ID")
    private String applicationId;
    @Column(name="SRVR_IP")
    private String serverIpAddress;
    @Column(name="TYP_CD")
    private String type;
    @Column(name="SVC_VER")
    private String serviceVersion;
    @Column(name="STAT_CD")
    private String statusCode;
    @Column(name="SVC_DSCRPTR_ID")
    private String serviceDescriptorId;
    @Column(name="CHKSM", length=30)
    private String checksum;
    @Version
    @Column(name="VER_NBR")
    private Long versionNumber;

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public QName getServiceName() {
        if (this.serviceName == null) {
            return null;
        }
        return QName.valueOf(this.serviceName);
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getServerIpAddress() {
        return this.serverIpAddress;
    }

    public void setServerIpAddress(String serverIpAddress) {
        this.serverIpAddress = serverIpAddress;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getServiceDescriptorId() {
        return this.serviceDescriptorId;
    }

    public void setServiceDescriptorId(String serviceDescriptorId) {
        this.serviceDescriptorId = serviceDescriptorId;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }

    public ServiceEndpointStatus getStatus() {
        if (this.getStatusCode() == null) {
            return null;
        }
        return ServiceEndpointStatus.fromCode((String)this.getStatusCode());
    }

    static ServiceInfo to(ServiceInfoBo bo) {
        if (bo == null) {
            return null;
        }
        return ServiceInfo.Builder.create((ServiceInfoContract)bo).build();
    }

    static ServiceInfoBo from(ServiceInfo im) {
        if (im == null) {
            return null;
        }
        ServiceInfoBo bo = new ServiceInfoBo();
        bo.serviceId = im.getServiceId();
        bo.serviceName = im.getServiceName().toString();
        bo.endpointUrl = im.getEndpointUrl();
        bo.instanceId = im.getInstanceId();
        bo.applicationId = im.getApplicationId();
        bo.serverIpAddress = im.getServerIpAddress();
        bo.type = im.getType();
        bo.serviceVersion = im.getServiceVersion();
        bo.statusCode = im.getStatus().getCode();
        bo.serviceDescriptorId = im.getServiceDescriptorId();
        bo.checksum = im.getChecksum();
        bo.versionNumber = im.getVersionNumber();
        return bo;
    }
}

