/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.web;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.security.PropertySuppressionService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConfigViewerAction extends KSBAction{

	private PropertySuppressionService propertySuppressionService;

	@Override
	public ActionMessages establishRequiredState(HttpServletRequest request, ActionForm actionForm) throws Exception {
		ConfigViewerForm form = (ConfigViewerForm) actionForm;
		form.setProperties(this.getFilteredConfigList());
				
		return null;
	}

	protected List<KeyValue> getFilteredConfigList(){
		return getPropertySuppressionService().suppressValueMap(cast(ConfigContext.getCurrentContextConfig().getProperties())).entrySet()
				.stream()
				.map(e -> new ConcreteKeyValue(e.getKey(), getPropertySuppressionService().suppressValue(e.getKey(), e.getValue())))
				.collect(Collectors.toList());
	}

	/**
	 * A Properties class is really a Map<String, String> even though the generic signature isn't defined that way.  Here is an easy workaround.
	 */
	@SuppressWarnings("unchecked")
	private <K, V> Map<K, V> cast(Map rawMap) {
		return rawMap;
	}

	@Override
	public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		return mapping.findForward("basic");
	}

	public PropertySuppressionService getPropertySuppressionService() {
		if (propertySuppressionService == null) {
			propertySuppressionService = GlobalResourceLoader.getService("propertySuppressionService");
		}

		return propertySuppressionService;
	}
}
