/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.api.country;

import org.kuali.rice.core.api.mo.common.Coded;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;

/**
 * Contract for a Country. Country is a basic abstraction over a Country, encapsulating its name, country code,
 * postal code, and if its restricted or not
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface CountryContract extends Versioned, Inactivatable, Coded {

    /**
     * {@inheritDoc}
     *
     * An abbreviated String representing the unique identifying code for a given country.  This code correlates
     * directly to the alpha-2 country codes from the ISO-3166-1-alpha-2 standard.
     * <p>This property is required to exist.</p>
     */
    @Override
    String getCode();

    /**
     * An alternative country code to represent a country. This code correlats directly to the alpha-3 codes
     * from the ISO_3166-1-alpha-3 standard.
     * <p>This property is optional</p>
     *
     * @return The alternate country code if it exists.  null is returned if an alternate code does not exist.
     */
    String getAlternateCode();

    /**
     * A full, familiar, name of a country.
     * <p>This property is optional</p>
     *
     * @return The name of a country if it exists.  null is returned if a full name does not exist.
     */
    String getName();

    /**
     * The name of a country according to CountryCodeDataTypeV3 in UniversalCodes-V2.0.xsd
     */
    String getNameV3();

    /**
     * Value representing whether a country is restricted.
     * <p>The meaning of restricted for a country varies depending upon the implementer - for instance if a country
     * may not be used in the address of a Vendor.</p>
     *
     * <p>The default value of this property is false.</p>
     *
     * @return if a country is restricted.
     */
    boolean isRestricted();
}
