/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.framework.campus;

import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.location.api.campus.CampusContract;
import org.kuali.rice.location.api.campus.CampusTypeContract;

/**
 * TODO: Likely should remove all methods from this interface after KULRICE-7170 is fixed
 */
public interface CampusEbo extends CampusContract, ExternalizableBusinessObject, MutableInactivatable {

    /**
     * This is the name for the Campus.
     *
     * <p>
     * It is a name a campus.
     * </p>
     *
     * @return name for Campus.
     */
    @Override
    String getName();

    /**
     * This is the short name for the Campus.
     *
     * <p>
     * It is a shorter name for a campus.
     * </p>
     *
     * @return short name for Campus.
     */
    @Override
    String getShortName();

    /**
     * This is the campus type for the Campus.
     *
     * <p>
     * It is a object that defines the type of a campus.
     * </p>
     *
     * @return short name for Campus.
     */
    @Override
    CampusTypeContract getCampusType();
    
    /**
     * The code value for this object.  In general a code value cannot be null or a blank string.
     *
     * @return the code value for this object.
     */
    @Override
    String getCode();
    
    /**
     * Returns the version number for this object.  In general, this value should only
     * be null if the object has not yet been stored to a persistent data store.
     * This version number is generally used for the purposes of optimistic locking.
     * 
     * @return the version number, or null if one has not been assigned yet
     */
    @Override
    Long getVersionNumber();
    
    /**
     * Return the globally unique object id of this object.  In general, this value should only
     * be null if the object has not yet been stored to a persistent data store.
     * 
     * @return the objectId of this object, or null if it has not been set yet
     */
    @Override
    String getObjectId();
    
    /**
     * The active indicator for an object.
     *
     * @return true if active false if not.
     */
    @Override
    boolean isActive();
    
    /**
     * Sets the record to active or inactive.
     */
    @Override
    void setActive(boolean active);
}
