/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.framework.campus;

import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.location.api.campus.CampusService;
import org.kuali.rice.location.api.campus.CampusType;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CampusTypeValuesFinder extends KeyValuesBase {

    @Override
	public List<KeyValue> getKeyValues() {

        // get a list of all CampusTypes
    	CampusService campusService = LocationApiServiceLocator.getCampusService();
    	List<CampusType> campusTypes = campusService.findAllCampusTypes();
       
    	//copy list for sorting (list from service is unmodifiable
    	List<CampusType> campusTypeSort = new ArrayList<CampusType>(campusTypes);
        // sort using comparator.
        Collections.sort(campusTypeSort, CampusTypeComparator.INSTANCE);

        // create a new list (code, descriptive-name)
        List<KeyValue> labels = new ArrayList<KeyValue>();

        for (CampusType campusType : campusTypeSort) {
            labels.add(new ConcreteKeyValue(campusType.getCode(), campusType.getCode() + " - " + campusType.getName()));
        }

        return labels;
    }
}
