/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.framework.state;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;
import org.kuali.rice.location.api.state.State;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StateValuesFinder extends KeyValuesBase {

    private String countryCode = "";

    @Override
    public List<KeyValue> getKeyValues() {
        if (StringUtils.isEmpty(this.countryCode)) {
            Country defaultCountry = LocationApiServiceLocator.getCountryService().getDefaultCountry();
            if (defaultCountry != null) {
                countryCode = defaultCountry.getCode();
            }
        }
        List<State> baseCodes = LocationApiServiceLocator.getStateService().findAllStatesInCountry(countryCode);

        return Stream.concat(
                Stream.of(new ConcreteKeyValue("", "")),
                baseCodes.stream()
                        .filter(State::isActive)
                        .map(state -> new ConcreteKeyValue(state.getCode(), getName(state)))
                        .sorted(Comparator.comparing(KeyValue::getValue))
        ).collect(Collectors.toList());
    }

    private String getName(State state) {
        return StringUtils.isNotBlank(state.getNameV3()) ? state.getNameV3() : state.getName();
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }


    @Override
    public void clearInternalCache() {
    }
}
