/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.impl.campus;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kns.kim.group.GroupTypeServiceBase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CampusGroupTypeServiceImpl extends GroupTypeServiceBase {

    @Override
    public List<String> getWorkflowRoutingAttributes(String routeLevel) {
        if (StringUtils.isBlank(routeLevel)) {
            throw new RiceIllegalArgumentException("routeLevel was blank or null");
        }

        final List<String> attrs = new ArrayList<String>(super.getWorkflowRoutingAttributes(routeLevel));
        attrs.add(KimConstants.AttributeConstants.CAMPUS_CODE);
        return Collections.unmodifiableList(attrs);
    }
}
