/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.bookstore.maintenance;

import edu.sampleu.bookstore.bo.Account;
import edu.sampleu.bookstore.bo.Author;
import edu.sampleu.bookstore.bo.Book;
import java.util.List;
import java.util.Map;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class BookMaintainable
extends KualiMaintainableImpl {
    private static final long serialVersionUID = 1L;

    public void saveBusinessObject() {
        Book book = (Book)this.getBusinessObject();
        List authors = book.getAuthors();
        for (Author author : authors) {
            Account account = (Account)author.getExtension();
            if (account != null && account.getAuthorId() == null) {
                author.setExtension(null);
            }
            KRADServiceLocator.getBusinessObjectService().save((PersistableBusinessObject)author);
            if (account == null || account.getAuthorId() != null) continue;
            account.setAuthorId(author.getAuthorId());
            KRADServiceLocator.getBusinessObjectService().save((PersistableBusinessObject)account);
        }
        book.setAuthors(authors);
        KRADServiceLocator.getBusinessObjectService().save((PersistableBusinessObject)book);
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        Book book = (Book)document.getNewMaintainableObject().getDataObject();
        book.setIsbn(null);
    }
}

