/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.kew.krad.controller;

import edu.sampleu.kew.krad.form.IngesterForm;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.impex.xml.CompositeXmlDocCollection;
import org.kuali.rice.core.api.impex.xml.FileXmlDocCollection;
import org.kuali.rice.core.api.impex.xml.XmlDoc;
import org.kuali.rice.core.api.impex.xml.XmlDocCollection;
import org.kuali.rice.core.api.impex.xml.ZipXmlDocCollection;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.controller.UifControllerBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ingester"})
public class IngesterController
extends UifControllerBase {
    protected IngesterForm createInitialForm(HttpServletRequest request) {
        return new IngesterForm();
    }

    @RequestMapping(params={"methodToCall=start"})
    public ModelAndView start(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        IngesterForm ingesterForm = (IngesterForm)form;
        return super.start((UifFormBase)ingesterForm, result, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=upload"})
    public ModelAndView upload(@ModelAttribute(value="KualiForm") IngesterForm ingesterForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        block31: {
            ArrayList<File> tempFiles = new ArrayList<File>();
            try {
                ArrayList<Object> collections = new ArrayList<Object>();
                for (MultipartFile file : ingesterForm.getFiles()) {
                    if (file == null || StringUtils.isBlank((String)file.getOriginalFilename())) continue;
                    FileOutputStream fos = null;
                    File temp = null;
                    try {
                        temp = File.createTempFile("ingester", null);
                        tempFiles.add(temp);
                        fos = new FileOutputStream(temp);
                        fos.write(file.getBytes());
                    }
                    catch (IOException ioe) {
                        GlobalVariables.getMessageMap().putErrorForSectionId("KEW-IngesterView", "error.ingester.copy.file.data", new String[]{file.getOriginalFilename(), ExceptionUtils.getFullStackTrace((Throwable)ioe)});
                        continue;
                    }
                    finally {
                        if (fos == null) continue;
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    if (file.getOriginalFilename().toLowerCase().endsWith(".zip")) {
                        try {
                            collections.add(new ZipXmlDocCollection(temp));
                        }
                        catch (IOException ioe) {
                            GlobalVariables.getMessageMap().putErrorForSectionId("KEW-IngesterView", "error.ingester.load.file", new String[]{file.getOriginalFilename()});
                        }
                        continue;
                    }
                    if (file.getOriginalFilename().endsWith(".xml")) {
                        collections.add(new FileXmlDocCollection(temp, file.getOriginalFilename()));
                        continue;
                    }
                    GlobalVariables.getMessageMap().putErrorForSectionId("KEW-IngesterView", "error.ingester.extraneous.file", new String[]{file.getOriginalFilename()});
                }
                if (collections.size() == 0) {
                    String message = "No valid files to ingest";
                    GlobalVariables.getMessageMap().putErrorForSectionId("KEW-IngesterView", "error.ingester.no.valid.files", new String[0]);
                    break block31;
                }
                CompositeXmlDocCollection compositeCollection = new CompositeXmlDocCollection(collections);
                int totalProcessed = 0;
                ArrayList<CompositeXmlDocCollection> c = new ArrayList<CompositeXmlDocCollection>(1);
                c.add(compositeCollection);
                try {
                    boolean txFailed;
                    Collection failed = CoreApiServiceLocator.getXmlIngesterService().ingest(c, GlobalVariables.getUserSession().getPrincipalId());
                    boolean bl = txFailed = failed.size() > 0;
                    if (txFailed) {
                        GlobalVariables.getMessageMap().putErrorForSectionId("KEW-IngesterView", "error.ingester.failed", new String[0]);
                    }
                    for (XmlDocCollection xmlDocCollection : collections) {
                        List docs = xmlDocCollection.getXmlDocs();
                        for (XmlDoc doc1 : docs) {
                            if (doc1.isProcessed()) {
                                if (!txFailed) {
                                    ++totalProcessed;
                                    GlobalVariables.getMessageMap().putInfoForSectionId("KEW-IngesterView", "info.ingester.success", new String[]{doc1.getName(), doc1.getProcessingMessage()});
                                    continue;
                                }
                                GlobalVariables.getMessageMap().putErrorForSectionId("KEW-IngesterView", "error.ingester.rolledback", new String[]{doc1.getName(), doc1.getProcessingMessage()});
                                continue;
                            }
                            GlobalVariables.getMessageMap().putErrorForSectionId("KEW-IngesterView", "error.ingester.failed.xml", new String[]{doc1.getName(), doc1.getProcessingMessage()});
                        }
                    }
                }
                catch (Exception e) {
                    GlobalVariables.getMessageMap().putErrorForSectionId("KEW-IngesterView", "error.ingester.during.inject", new String[]{ExceptionUtils.getFullStackTrace((Throwable)e)});
                }
                if (totalProcessed == 0) {
                    GlobalVariables.getMessageMap().putErrorForSectionId("KEW-IngesterView", "error.ingester.no.xmls", new String[0]);
                }
            }
            finally {
                if (tempFiles.size() > 0) {
                    for (File tempFile : tempFiles) {
                        if (tempFile.delete()) continue;
                    }
                }
            }
        }
        return this.getUIFModelAndView((UifFormBase)ingesterForm);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=close"})
    public ModelAndView close(@ModelAttribute(value="KualiForm") IngesterForm ingesterForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        return null;
    }
}

