/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.service;

import edu.sampleu.travel.bo.FiscalOfficer;
import edu.sampleu.travel.bo.TravelAccount;
import edu.sampleu.travel.dto.FiscalOfficerInfo;
import edu.sampleu.travel.dto.TravelAccountInfo;
import edu.sampleu.travel.service.FiscalOfficerService;
import edu.sampleu.travel.service.TravelAccountService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LookupService;
import org.springframework.beans.BeanUtils;

public class FiscalOfficerTravelAccountServiceImpl
implements FiscalOfficerService,
TravelAccountService {
    protected static String[] FOI_SKIP = new String[]{"accounts"};
    protected BusinessObjectService businessObjectService;
    protected LookupService lookupService;

    public FiscalOfficerInfo createFiscalOfficer(FiscalOfficerInfo fiscalOfficerInfo) {
        this.getBusinessObjectService().save((PersistableBusinessObject)this.toFiscalOfficer(fiscalOfficerInfo));
        HashMap<String, Long> criteria = new HashMap<String, Long>();
        criteria.put("id", fiscalOfficerInfo.getId());
        FiscalOfficer fiscalOfficer = (FiscalOfficer)this.getBusinessObjectService().findByPrimaryKey(FiscalOfficer.class, criteria);
        return this.toFiscalOfficerInfo(fiscalOfficer);
    }

    public List<FiscalOfficerInfo> lookupFiscalOfficer(Map<String, String> criteria) {
        Collection temp = this.getLookupService().findCollectionBySearch(FiscalOfficer.class, criteria);
        ArrayList<FiscalOfficerInfo> results = new ArrayList<FiscalOfficerInfo>();
        if (temp != null) {
            for (FiscalOfficer fiscalOfficer : temp) {
                results.add(this.toFiscalOfficerInfo(fiscalOfficer));
            }
        }
        return results;
    }

    public FiscalOfficerInfo retrieveFiscalOfficer(Long id) {
        FiscalOfficer temp = (FiscalOfficer)this.getBusinessObjectService().findBySinglePrimaryKey(FiscalOfficer.class, (Object)id);
        FiscalOfficerInfo result = this.toFiscalOfficerInfo(temp);
        return result;
    }

    public FiscalOfficerInfo updateFiscalOfficer(FiscalOfficerInfo fiscalOfficerInfo) {
        FiscalOfficer fiscalOfficer = (FiscalOfficer)this.getBusinessObjectService().findBySinglePrimaryKey(FiscalOfficer.class, (Object)fiscalOfficerInfo.getId());
        if (fiscalOfficer != null) {
            this.getBusinessObjectService().save((PersistableBusinessObject)this.toFiscalOfficerUpdate(fiscalOfficerInfo, fiscalOfficer));
            fiscalOfficer = (FiscalOfficer)this.getBusinessObjectService().findBySinglePrimaryKey(FiscalOfficer.class, (Object)fiscalOfficerInfo.getId());
        }
        return this.toFiscalOfficerInfo(fiscalOfficer);
    }

    public TravelAccountInfo retrieveTravelAccount(String number) {
        TravelAccount temp = (TravelAccount)this.getBusinessObjectService().findBySinglePrimaryKey(TravelAccount.class, (Object)number);
        TravelAccountInfo result = this.toTravelAccountInfo(temp);
        return result;
    }

    protected FiscalOfficer toFiscalOfficerUpdate(FiscalOfficerInfo fiscalOfficerInfo, FiscalOfficer fiscalOfficer) {
        BeanUtils.copyProperties((Object)fiscalOfficerInfo, (Object)fiscalOfficer, (String[])FOI_SKIP);
        ArrayList<TravelAccountInfo> newAccounts = new ArrayList<TravelAccountInfo>();
        HashMap<String, TravelAccountInfo> accountInfoMap = new HashMap<String, TravelAccountInfo>();
        for (TravelAccountInfo accountInfo : fiscalOfficerInfo.getAccounts()) {
            if (accountInfo.getVersionNumber() == null) {
                newAccounts.add(accountInfo);
                continue;
            }
            accountInfoMap.put(accountInfo.getNumber(), accountInfo);
        }
        for (TravelAccount account : fiscalOfficer.getAccounts()) {
            TravelAccountInfo accountInfo = (TravelAccountInfo)accountInfoMap.get(account.getNumber());
            if (accountInfo == null) {
                account.setFoId(null);
                account.setFiscalOfficer(null);
                continue;
            }
            BeanUtils.copyProperties((Object)accountInfo, (Object)account);
        }
        for (TravelAccountInfo accountInfo : newAccounts) {
            fiscalOfficer.getAccounts().add(this.toTravelAccount(accountInfo));
        }
        return fiscalOfficer;
    }

    protected FiscalOfficer toFiscalOfficer(FiscalOfficerInfo fiscalOfficerInfo) {
        FiscalOfficer fiscalOfficer = new FiscalOfficer();
        BeanUtils.copyProperties((Object)fiscalOfficerInfo, (Object)fiscalOfficer, (String[])FOI_SKIP);
        if (fiscalOfficerInfo.getAccounts() != null) {
            for (TravelAccountInfo accountInfo : fiscalOfficerInfo.getAccounts()) {
                fiscalOfficer.getAccounts().add(this.toTravelAccount(accountInfo));
            }
        }
        return fiscalOfficer;
    }

    protected FiscalOfficerInfo toFiscalOfficerInfo(FiscalOfficer fiscalOfficer) {
        FiscalOfficerInfo fiscalOfficerInfo = null;
        if (fiscalOfficer != null) {
            fiscalOfficerInfo = new FiscalOfficerInfo();
            BeanUtils.copyProperties((Object)fiscalOfficer, (Object)fiscalOfficerInfo, (String[])FOI_SKIP);
            if (fiscalOfficer.getAccounts() != null) {
                ArrayList<TravelAccountInfo> accountInfoList = new ArrayList<TravelAccountInfo>();
                for (TravelAccount travelAccount : fiscalOfficer.getAccounts()) {
                    accountInfoList.add(this.toTravelAccountInfo(travelAccount));
                }
                fiscalOfficerInfo.setAccounts(accountInfoList);
            }
        }
        return fiscalOfficerInfo;
    }

    protected TravelAccountInfo toTravelAccountInfo(TravelAccount travelAccount) {
        TravelAccountInfo travelAccountInfo = new TravelAccountInfo();
        BeanUtils.copyProperties((Object)travelAccount, (Object)travelAccountInfo);
        return travelAccountInfo;
    }

    protected TravelAccount toTravelAccount(TravelAccountInfo travelAccountInfo) {
        TravelAccount travelAccount = new TravelAccount();
        BeanUtils.copyProperties((Object)travelAccountInfo, (Object)travelAccount);
        return travelAccount;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = KRADServiceLocatorWeb.getLookupService();
        }
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }
}

