/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.kew.krad.form;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.stats.Stats;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.form.UifFormBase;

public class StatsForm
extends UifFormBase {
    private static final long serialVersionUID = 4587377779133823858L;
    private static final Logger LOG = Logger.getLogger(StatsForm.class);
    private static final String BEGIN_DATE = "begDate";
    private static final String END_DATE = "endDate";
    public static final String DAY_TIME_UNIT = "DDD";
    public static final String WEEK_TIME_UNIT = "WW";
    public static final String MONTH_TIME_UNIT = "MM";
    public static final String YEAR_TIME_UNIT = "YYYY";
    public static final String DEFAULT_BEGIN_DATE = "01/01/1900";
    public static final String DEFAULT_END_DATE = "01/01/2400";
    public static final String BEG_DAY_TIME = " 00:00";
    public static final String END_DAY_TIME = " 23:59";
    public static final String DATE_FORMAT = "MM/dd/yyyy";
    public static final String TIME_FORMAT = " HH:mm";
    private Stats stats = new Stats();
    private String methodToCall = "";
    private String avgActionsPerTimeUnit = "DDD";
    private String begDate;
    private String endDate;
    private Date beginningDate;
    private Date endingDate;
    private String backLocation;

    public void determineBeginDate() {
        block11: {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm");
            this.beginningDate = null;
            try {
                this.beginningDate = this.getBegDate() == null || this.getBegDate().trim().equals("") ? dateFormat.parse("01/01/1900 00:00") : dateFormat.parse(this.getBegDate() + BEG_DAY_TIME);
                dateFormat = new SimpleDateFormat(DATE_FORMAT);
                this.begDate = dateFormat.format(this.beginningDate);
            }
            catch (ParseException e) {
                if (this.beginningDate != null) break block11;
                try {
                    this.beginningDate = dateFormat.parse("01/01/1900 00:00");
                }
                catch (ParseException e2) {
                    throw new RuntimeException("Default Begin Date format incorrect", e2);
                }
            }
            finally {
                if (this.beginningDate == null) {
                    try {
                        this.beginningDate = dateFormat.parse("01/01/1900 00:00");
                    }
                    catch (ParseException e) {
                        throw new RuntimeException("Default Begin Date format incorrect", e);
                    }
                }
            }
        }
    }

    public void determineEndDate() {
        block11: {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm");
            this.endingDate = null;
            try {
                this.endingDate = this.getEndDate() == null || this.getEndDate().trim().equals("") ? dateFormat.parse("01/01/2400 23:59") : dateFormat.parse(this.getEndDate() + END_DAY_TIME);
                dateFormat = new SimpleDateFormat(DATE_FORMAT);
                this.endDate = dateFormat.format(this.endingDate);
            }
            catch (ParseException e) {
                if (this.endingDate != null) break block11;
                try {
                    this.endingDate = dateFormat.parse("01/01/2400 23:59");
                }
                catch (ParseException e2) {
                    throw new RuntimeException("Default End Date format incorrect", e2);
                }
            }
            finally {
                if (this.endingDate == null) {
                    try {
                        this.endingDate = dateFormat.parse("01/01/2400 23:59");
                    }
                    catch (ParseException e) {
                        throw new RuntimeException("Default End Date format incorrect", e);
                    }
                }
            }
        }
    }

    public Map makePerUnitOfTimeDropDownMap() {
        HashMap<String, String> dropDownMap = new HashMap<String, String>();
        dropDownMap.put(DAY_TIME_UNIT, "Daily");
        dropDownMap.put(WEEK_TIME_UNIT, "Weekly");
        dropDownMap.put(MONTH_TIME_UNIT, "Monthly");
        dropDownMap.put(YEAR_TIME_UNIT, "Yearly");
        return dropDownMap;
    }

    public void validateDates() {
        LOG.debug((Object)"validate()");
        if (this.getBegDate() != null && this.getBegDate().length() != 0) {
            try {
                new SimpleDateFormat("MM/dd/yyyy HH:mm").parse(this.getBegDate().trim() + END_DAY_TIME);
            }
            catch (ParseException e) {
                GlobalVariables.getMessageMap().putError(BEGIN_DATE, "general.error.fieldinvalid", new String[]{"Begin Date"});
            }
        }
        if (this.getEndDate() != null && this.getEndDate().length() != 0) {
            try {
                new SimpleDateFormat("MM/dd/yyyy HH:mm").parse(this.getEndDate().trim() + END_DAY_TIME);
            }
            catch (ParseException e) {
                GlobalVariables.getMessageMap().putError(END_DATE, "general.error.fieldinvalid", new String[]{"End Date"});
            }
        }
    }

    public Stats getStats() {
        return this.stats;
    }

    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public String getCanceledLabel() {
        return "CANCELED";
    }

    public String getDisapprovedLabel() {
        return "DISAPPROVED";
    }

    public String getEnrouteLabel() {
        return "ENROUTE";
    }

    public String getExceptionLabel() {
        return "EXCEPTION";
    }

    public String getFinalLabel() {
        return "FINAL";
    }

    public String getInitiatedLabel() {
        return "INITIATED";
    }

    public String getProcessedLabel() {
        return "PROCESSED";
    }

    public String getSavedLabel() {
        return "SAVED";
    }

    public String getAvgActionsPerTimeUnit() {
        return this.avgActionsPerTimeUnit;
    }

    public void setAvgActionsPerTimeUnit(String string) {
        this.avgActionsPerTimeUnit = string;
    }

    public String getBegDate() {
        return this.begDate;
    }

    public void setBegDate(String begDate) {
        this.begDate = begDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getMethodToCall() {
        return this.methodToCall;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    public Date getBeginningDate() {
        return this.beginningDate;
    }

    public void setBeginningDate(Date beginningDate) {
        this.beginningDate = beginningDate;
    }

    public Date getEndingDate() {
        return this.endingDate;
    }

    public void setEndingDate(Date endingDate) {
        this.endingDate = endingDate;
    }

    public String getDayTimeUnit() {
        return DAY_TIME_UNIT;
    }

    public String getMonthTimeUnit() {
        return MONTH_TIME_UNIT;
    }

    public String getWeekTimeUnit() {
        return WEEK_TIME_UNIT;
    }

    public String getYearTimeUnit() {
        return YEAR_TIME_UNIT;
    }

    public String getBackLocation() {
        return this.backLocation;
    }

    public void setBackLocation(String backLocation) {
        this.backLocation = backLocation;
    }
}

