/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.config;

import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.kuali.common.jdbc.project.spring.JdbcPropertyLocationsConfig;
import org.kuali.common.util.log.LoggerUtils;
import org.kuali.common.util.properties.PropertiesService;
import org.kuali.common.util.properties.spring.DefaultPropertiesServiceConfig;
import org.kuali.common.util.spring.service.PropertySourceConfig;
import org.kuali.rice.config.SampleAppProjectConfig;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.config.property.ConfigPropertySource;
import org.kuali.rice.sql.spring.SourceSqlPropertyLocationsConfig;
import org.kuali.rice.xml.ingest.RiceConfigUtils;
import org.kuali.rice.xml.spring.IngestXmlPropertyLocationsConfig;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.PropertySource;

@Configuration
@Import(value={SampleAppProjectConfig.class, JdbcPropertyLocationsConfig.class, DefaultPropertiesServiceConfig.class, SourceSqlPropertyLocationsConfig.class, IngestXmlPropertyLocationsConfig.class})
public class SampleAppPSC
implements PropertySourceConfig {
    private static final String KR_SAMPLE_APP_CONFIG = "classpath:META-INF/sample-app-config.xml";
    private static final Logger logger = LoggerUtils.make();
    @Autowired
    JdbcPropertyLocationsConfig jdbcConfig;
    @Autowired
    SourceSqlPropertyLocationsConfig sourceSqlConfig;
    @Autowired
    IngestXmlPropertyLocationsConfig ingestXmlConfig;
    @Autowired
    PropertiesService service;
    @Autowired
    ServletContext servletContext;

    @Bean
    public PropertySource<?> propertySource() {
        ArrayList locations = new ArrayList();
        locations.addAll(this.jdbcConfig.jdbcPropertyLocations());
        locations.addAll(this.sourceSqlConfig.riceSourceSqlPropertyLocations());
        locations.addAll(this.ingestXmlConfig.riceIngestXmlPropertyLocations());
        Properties properties = this.service.getProperties(locations);
        logger.info("Loaded {} regular properties", (Object)properties.size());
        Config rootCfg = RiceConfigUtils.getRootConfig((Properties)properties, (String)KR_SAMPLE_APP_CONFIG, (ServletContext)this.servletContext);
        ConfigContext.init((Config)rootCfg);
        return new ConfigPropertySource("riceConfig", rootCfg);
    }
}

