/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.workflow;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.framework.support.krms.RulesEngineExecutor;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.krms.api.engine.Engine;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.w3c.dom.Document;

public class TravelAccountRulesEngineExecutor
implements RulesEngineExecutor {
    private static final String CONTEXT_NAMESPACE_CODE = "KR-SAP";
    private static final String CONTEXT_NAME = "Travel Account";

    public EngineResults execute(RouteContext routeContext, Engine engine) {
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        contextQualifiers.put("namespaceCode", CONTEXT_NAMESPACE_CODE);
        contextQualifiers.put("name", CONTEXT_NAME);
        SelectionCriteria sectionCriteria = SelectionCriteria.createCriteria(null, contextQualifiers, Collections.singletonMap("Campus", "BL"));
        String docContent = routeContext.getDocument().getDocContent();
        String subsidizedPercentStr = this.getElementValue(docContent, "//newMaintainableObject//subsidizedPercent");
        String accountTypeCode = this.getElementValue(docContent, "//newMaintainableObject/dataObject/extension/accountTypeCode");
        String initiator = this.getElementValue(docContent, "//documentInitiator//principalId");
        Facts.Builder factsBuilder = Facts.Builder.create();
        if (StringUtils.isNotEmpty((String)subsidizedPercentStr)) {
            factsBuilder.addFact("Subsidized Percent", (Object)Double.valueOf(subsidizedPercentStr));
        }
        factsBuilder.addFact("Account Type Code", (Object)accountTypeCode);
        factsBuilder.addFact("Initiator Principal ID", (Object)initiator);
        return engine.execute(sectionCriteria, factsBuilder.build(), null);
    }

    private String getElementValue(String docContent, String xpathExpression) {
        try {
            Document document = XmlHelper.trimXml((InputStream)new ByteArrayInputStream(docContent.getBytes()));
            XPath xpath = XPathHelper.newXPath();
            String value = (String)xpath.evaluate(xpathExpression, document, XPathConstants.STRING);
            return value;
        }
        catch (Exception e) {
            throw new RiceRuntimeException();
        }
    }
}

