/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.sql.spring;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.kuali.common.jdbc.project.spring.JdbcPropertyLocationsConfig;
import org.kuali.common.util.properties.PropertiesService;
import org.kuali.common.util.properties.spring.DefaultPropertiesServiceConfig;
import org.kuali.common.util.spring.PropertySourceUtils;
import org.kuali.common.util.spring.service.PropertySourceConfig;
import org.kuali.rice.sql.spring.SourceSqlProjectConfig;
import org.kuali.rice.sql.spring.SourceSqlPropertyLocationsConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.PropertySource;

@Configuration
@Import(value={SourceSqlProjectConfig.class, SourceSqlPropertyLocationsConfig.class, JdbcPropertyLocationsConfig.class, DefaultPropertiesServiceConfig.class})
public class SourceSqlPSC
implements PropertySourceConfig {
    @Autowired
    JdbcPropertyLocationsConfig jdbcConfig;
    @Autowired
    SourceSqlPropertyLocationsConfig sourceSqlConfig;
    @Autowired
    PropertiesService service;

    @Bean
    public PropertySource<?> propertySource() {
        ArrayList locations = Lists.newArrayList();
        locations.addAll(this.jdbcConfig.jdbcPropertyLocations());
        locations.addAll(this.sourceSqlConfig.riceSourceSqlPropertyLocations());
        return PropertySourceUtils.getPropertySource((PropertiesService)this.service, (List)locations);
    }
}

