/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.sql.spring;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.execute.spring.ExecutableConfig;
import org.kuali.common.util.properties.spring.EnvironmentPropertySourceConfig;
import org.kuali.common.util.runonce.smart.PropertiesFileRunOnce;
import org.kuali.common.util.runonce.smart.RunOnce;
import org.kuali.common.util.runonce.smart.RunOnceExecutable;
import org.kuali.common.util.spring.SpringExecUtils;
import org.kuali.common.util.spring.SpringExecutable;
import org.kuali.common.util.spring.service.SpringService;
import org.kuali.common.util.spring.service.SpringServiceConfig;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.sql.spring.SourceSqlExecConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.PropertySource;

@Configuration
@Import(value={SpringServiceConfig.class, EnvironmentPropertySourceConfig.class})
public class SourceSqlRunOnceConfig
implements ExecutableConfig {
    private static final String PROJECT_HOME_KEY = "project.home";
    private static final String RUNONCE_FILENAME = "runonce.properties";
    private static final String ENCODING = "UTF-8";
    private static final String PROPERTY_KEY = "project.db.reset";
    @Autowired
    SpringService service;
    @Autowired
    PropertySource<?> propertySource;

    @Bean(initMethod="execute")
    public Executable executable() {
        Properties properties = ConfigContext.getCurrentContextConfig().getProperties();
        String projectHome = properties.getProperty(PROJECT_HOME_KEY);
        File file = new File(projectHome, RUNONCE_FILENAME);
        PropertiesFileRunOnce runOnce = PropertiesFileRunOnce.builder((File)file, (String)ENCODING, (String)PROPERTY_KEY).build();
        SpringExecutable executable = SpringExecUtils.getSpringExecutable((SpringService)this.service, this.propertySource, SourceSqlExecConfig.class, (List)Lists.newArrayList((Object[])new String[]{"master"}));
        return RunOnceExecutable.builder((Executable)executable, (RunOnce)runOnce).build();
    }
}

