/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.web.health;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.kuali.rice.web.health.HealthMetric;

public class HealthStatus {
    public static final String OK = "Ok";
    public static final String FAILED = "Failed";
    @JsonProperty(value="Status")
    private String statusCode;
    @JsonProperty(value="Message")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String message;
    @JsonProperty(value="Metrics")
    private List<HealthMetric> metrics;

    public HealthStatus() {
        this(OK);
    }

    public HealthStatus(String statusCode) {
        this.setStatusCode(statusCode);
        this.setMetrics(new ArrayList());
    }

    @JsonIgnore
    public boolean isOk() {
        return OK.equals(this.statusCode);
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        if (!statusCode.equals(OK) && !statusCode.equals(FAILED)) {
            throw new IllegalArgumentException("Status code must be one of 'Ok' or 'Failed'");
        }
        this.statusCode = statusCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<HealthMetric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<HealthMetric> metrics) {
        if (metrics == null) {
            throw new IllegalArgumentException("metrics list must not be null");
        }
        this.metrics = metrics;
    }

    public void appendMessage(String metricName, String message) {
        String fullMessage = "* " + metricName + " -> " + message;
        if (this.getMessage() == null) {
            this.setMessage(fullMessage);
        } else {
            this.setMessage(this.getMessage() + " " + fullMessage);
        }
    }
}

