/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.web.health;

import com.amazonaws.services.s3.AmazonS3;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Map;
import java.util.SortedMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.web.health.AmazonS3ConnectionHealthGauge;
import org.kuali.rice.web.health.DatabaseConnectionHealthGauge;
import org.kuali.rice.web.health.DatabaseConnectionPoolHealthCheck;
import org.kuali.rice.web.health.DatabaseConnectionPoolMetricSet;
import org.kuali.rice.web.health.HealthMetric;
import org.kuali.rice.web.health.HealthServlet;
import org.kuali.rice.web.health.HealthStatus;
import org.kuali.rice.web.health.MemoryUsageHealthCheck;
import org.kuali.rice.web.health.MemoryUsageRatio;

public class HealthServlet
extends HttpServlet {
    private MetricRegistry metricRegistry;
    private HealthCheckRegistry healthCheckRegistry;
    private Config config;

    public void init() throws ServletException {
        this.metricRegistry = new MetricRegistry();
        this.healthCheckRegistry = new HealthCheckRegistry();
        this.config = new Config();
        this.monitorMemoryUsage();
        this.monitorThreads();
        this.monitorGarbageCollection();
        this.monitorBufferPools();
        this.monitorClassLoading();
        this.monitorFileDescriptors();
        this.monitorRuntime();
        this.monitorDataSources();
        this.monitorAmazonS3();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HealthStatus status = this.checkHealth();
        String includeDetail = req.getParameter("detail");
        if ("true".equals(includeDetail)) {
            if (status.isOk()) {
                resp.setStatus(200);
            } else {
                resp.setStatus(503);
            }
            ObjectMapper mapper = new ObjectMapper();
            resp.setContentType("application/json");
            mapper.writeValue((OutputStream)resp.getOutputStream(), (Object)status);
        } else if (status.isOk()) {
            resp.setStatus(204);
        } else {
            resp.setStatus(503);
        }
        resp.getOutputStream().flush();
    }

    private void monitorMemoryUsage() {
        MemoryUsageGaugeSet gaugeSet = new MemoryUsageGaugeSet();
        Map metrics = gaugeSet.getMetrics();
        for (String metricName : metrics.keySet()) {
            this.metricRegistry.register("memory:" + metricName, (Metric)metrics.get(metricName));
        }
        Gauge heapUsage = (Gauge)this.metricRegistry.getGauges().get("memory:heap.usage");
        Gauge heapMaxMemory = (Gauge)this.metricRegistry.getGauges().get("memory:heap.max");
        if ((Long)heapMaxMemory.getValue() != -1L) {
            this.healthCheckRegistry.register("memory:heap.usage", (HealthCheck)new MemoryUsageHealthCheck(heapUsage, this.config.heapMemoryUsageThreshold()));
        }
        Gauge nonHeapUsage = (Gauge)this.metricRegistry.getGauges().get("memory:non-heap.usage");
        Gauge nonHeapMaxMemory = (Gauge)this.metricRegistry.getGauges().get("memory:non-heap.max");
        if ((Long)nonHeapMaxMemory.getValue() != -1L) {
            this.healthCheckRegistry.register("memory:non-heap.usage", (HealthCheck)new MemoryUsageHealthCheck(nonHeapUsage, this.config.nonHeapMemoryUsageThreshold()));
        }
        Gauge totalUsedMemory = (Gauge)this.metricRegistry.getGauges().get("memory:total.used");
        Gauge totalMaxMemory = (Gauge)this.metricRegistry.getGauges().get("memory:total.max");
        if ((Long)totalMaxMemory.getValue() != -1L) {
            MemoryUsageRatio totalMemoryRatio = new MemoryUsageRatio(totalUsedMemory, totalMaxMemory);
            this.metricRegistry.register("memory:total.usage", (Metric)totalMemoryRatio);
            this.healthCheckRegistry.register("memory:total.usage", (HealthCheck)new MemoryUsageHealthCheck((Gauge)totalMemoryRatio, this.config.totalMemoryUsageThreshold()));
        }
    }

    private void monitorThreads() {
        ThreadStatesGaugeSet gaugeSet = new ThreadStatesGaugeSet();
        Map metrics = gaugeSet.getMetrics();
        for (String name : metrics.keySet()) {
            this.metricRegistry.register("thread:" + name, (Metric)metrics.get(name));
        }
        String deadlockCountName = "thread:deadlock.count";
        Gauge deadlockCount = (Gauge)this.metricRegistry.getGauges().get(deadlockCountName);
        this.healthCheckRegistry.register("thread:deadlock.count", (HealthCheck)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void monitorGarbageCollection() {
        GarbageCollectorMetricSet metricSet = new GarbageCollectorMetricSet();
        Map metrics = metricSet.getMetrics();
        for (String name : metrics.keySet()) {
            this.metricRegistry.register("garbage-collector:" + name, (Metric)metrics.get(name));
        }
    }

    private void monitorBufferPools() {
        BufferPoolMetricSet metricSet = new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer());
        Map metrics = metricSet.getMetrics();
        for (String name : metrics.keySet()) {
            this.metricRegistry.register("buffer-pool:" + name, (Metric)metrics.get(name));
        }
    }

    private void monitorClassLoading() {
        ClassLoadingGaugeSet metricSet = new ClassLoadingGaugeSet();
        Map metrics = metricSet.getMetrics();
        for (String name : metrics.keySet()) {
            this.metricRegistry.register("classloader:" + name, (Metric)metrics.get(name));
        }
    }

    private void monitorFileDescriptors() {
        FileDescriptorRatioGauge gauge = new FileDescriptorRatioGauge();
        String name = "file-descriptor:usage";
        this.metricRegistry.register(name, (Metric)gauge);
        this.healthCheckRegistry.register(name, (HealthCheck)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void monitorRuntime() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        this.metricRegistry.register("runtime:uptime", (Metric)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void monitorDataSources() {
        DataSource dataSource = (DataSource)ConfigContext.getCurrentContextConfig().getObject("datasource");
        DataSource nonTransactionalDataSource = (DataSource)ConfigContext.getCurrentContextConfig().getObject("nonTransactionalDatasource");
        DataSource serverDataSource = (DataSource)ConfigContext.getCurrentContextConfig().getObject("serverDatasource");
        DatabasePlatform databasePlatform = (DatabasePlatform)GlobalResourceLoader.getService((String)"dbPlatform");
        this.monitorDataSource("database.primary:", dataSource, databasePlatform, this.config.primaryConnectionPoolUsageThreshold());
        this.monitorDataSource("database.non-transactional:", nonTransactionalDataSource, databasePlatform, this.config.nonTransactionalConnectionPoolUsageThreshold());
        this.monitorDataSource("database.server:", serverDataSource, databasePlatform, this.config.serverConnectionPoolUsageThreshold());
    }

    private void monitorDataSource(String namePrefix, DataSource dataSource, DatabasePlatform databasePlatform, double threshold) {
        if (databasePlatform != null && dataSource != null) {
            String name = namePrefix + "connected";
            DatabaseConnectionHealthGauge healthGauge = new DatabaseConnectionHealthGauge(dataSource, databasePlatform);
            this.metricRegistry.register(name, (Metric)healthGauge);
            this.healthCheckRegistry.register(name, (HealthCheck)healthGauge);
            String poolUsageName = namePrefix + "pool.usage";
            DatabaseConnectionPoolMetricSet poolMetrics = new DatabaseConnectionPoolMetricSet(namePrefix, dataSource);
            this.metricRegistry.registerAll((MetricSet)poolMetrics);
            Gauge poolUsage = (Gauge)this.metricRegistry.getGauges().get(poolUsageName);
            if (poolUsage != null) {
                this.healthCheckRegistry.register(poolUsageName, (HealthCheck)new DatabaseConnectionPoolHealthCheck(poolUsage, threshold));
            }
        }
    }

    private void monitorAmazonS3() {
        AmazonS3 amazonS3 = (AmazonS3)GlobalResourceLoader.getService((String)"amazonS3");
        if (amazonS3 != null) {
            AmazonS3ConnectionHealthGauge gauge = new AmazonS3ConnectionHealthGauge(amazonS3);
            String name = "amazonS3:connected";
            this.metricRegistry.register(name, (Metric)gauge);
            this.healthCheckRegistry.register(name, (HealthCheck)gauge);
        }
    }

    private HealthStatus checkHealth() {
        HealthStatus status = new HealthStatus();
        this.runHealthChecks(status);
        this.reportMetrics(status);
        return status;
    }

    private void runHealthChecks(HealthStatus status) {
        SortedMap results = this.healthCheckRegistry.runHealthChecks();
        for (String name : results.keySet()) {
            HealthCheck.Result result = (HealthCheck.Result)results.get(name);
            if (result.isHealthy()) continue;
            status.setStatusCode("Failed");
            status.appendMessage(name, result.getMessage());
        }
    }

    private void reportMetrics(HealthStatus status) {
        this.reportGauges((Map)this.metricRegistry.getGauges(), status);
        this.reportCounters((Map)this.metricRegistry.getCounters(), status);
        this.reportHistograms((Map)this.metricRegistry.getHistograms(), status);
        this.reportMeters((Map)this.metricRegistry.getMeters(), status);
        this.reportTimers((Map)this.metricRegistry.getTimers(), status);
    }

    private void reportGauges(Map<String, Gauge> gaugues, HealthStatus status) {
        for (String name : gaugues.keySet()) {
            Gauge gauge = gaugues.get(name);
            status.getMetrics().add(new HealthMetric(name, gauge.getValue()));
        }
    }

    private void reportCounters(Map<String, Counter> counters, HealthStatus status) {
        for (String name : counters.keySet()) {
            Counter counter = counters.get(name);
            status.getMetrics().add(new HealthMetric(name, (Object)counter.getCount()));
        }
    }

    private void reportHistograms(Map<String, Histogram> histograms, HealthStatus status) {
        for (String name : histograms.keySet()) {
            Histogram histogram = histograms.get(name);
            status.getMetrics().add(new HealthMetric(name, (Object)histogram.getCount()));
        }
    }

    private void reportMeters(Map<String, Meter> meters, HealthStatus status) {
        for (String name : meters.keySet()) {
            Meter meter = meters.get(name);
            status.getMetrics().add(new HealthMetric(name, (Object)meter.getCount()));
        }
    }

    private void reportTimers(Map<String, Timer> timers, HealthStatus status) {
        for (String name : timers.keySet()) {
            Timer timer = timers.get(name);
            status.getMetrics().add(new HealthMetric(name, (Object)timer.getCount()));
        }
    }

    static /* synthetic */ Config access$000(HealthServlet x0) {
        return x0.config;
    }
}

