/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

var ADD = '.kr-add-button';
var CUT='.kr-cut-button';
var PASTE='.kr-paste-button';
var DELETE='.kr-delete-button';
var REFRESH='.kr-refresh-button';
var ADDPARENT='.kr-addparent-button';
var EDIT='.kr-edit-button';
var TREE = '.tree-bar-button';

var ENABLED = true;
var pasting = false;

function disableButton(id) {
    if (ENABLED && jq(id) != null) {
        jq(id).attr('disabled', true);
//        not using grayed out images yet..
//        jq(id + ' > img').attr('src', 'yourdisabledimg.jpg');
//        did the css stuff in a new css-class
//        jq(id).css('cursor', 'default');
//        jq(id).css('color', 'gray');
        jq(id).removeClass('kr-button-primary');
        jq(id).removeClass('kr-button-secondary1');
        jq(id).addClass('kr-button-primary-disabled');
    }    
}

function enableButton(id) {
    if (ENABLED && jq(id) != null) {
        jq(id).removeAttr('disabled');
        jq(id).removeClass('kr-button-primary-disabled');
        jq(id).addClass('kr-button-primary');
    }
}

function enableAddButton() {
    enableButton(ADD);
}

function enablePasteButton() {
    pasting = true;
    enableButton(PASTE);
}

function enableDeleteButton() {
    enableButton(DELETE);
}

function enableRefreshButton() {
    enableButton(REFRESH);
}

function enableAddParentButton() {
    enableButton(ADDPARENT);
}

function enableEditButton() {
    enableButton(EDIT);
}
function enableTreeButtons() {
    enableButton(TREE);
    if (!pasting) {
        disablePasteButton();
    }
}

function disablePasteButton() {
    pasting = false;
    disableButton(PASTE);
}

function disableTreeButtons() {
    disableButton(TREE);
}


function cutPasteButtonInit() {
    // CUT
    if (jq('.kr-cut-button') != undefined && jq('.kr-cut-button') != null) {
        jq('.kr-cut-button').click(function() {
            enablePasteButton();
        });
    }
}


function propButtonsInit() {
    disableTreeButtons();

    if (propositionAddInProgress()) {
        disablePasteButton();
        enableDeleteButton();
    } else {
        cutPasteButtonInit();
        enableAddButton();
        enableRefreshButton();
        selectedCheck();
        selectedPropCheck();
    }
}

var onProp = false;
function enabledCheck(command) {
    if (onProp) return true;

    if (command == 'edit') {
        onProp = true;
        propButtonsInit();
    } else if (command == 'add') {
        onProp = true;
        propButtonsInit();
    } else if (command == 'addparent') {
        onProp = true;
        propButtonsInit();
    } else if (command == 'left') {
        onProp = true;
        propButtonsInit();
    } else if (command == 'right') {
        onProp = true;
        propButtonsInit();
    } else if (command == 'up') {
        onProp = true;
        propButtonsInit();
    } else if (command == 'down') {
        onProp = true;
        propButtonsInit();
    } else if (command == 'cut') {
        onProp = true;
        propButtonsInit();
        enablePasteButton(); // clicks have not been inited yet, enable paste button
    } else if (command == 'paste') {
        onProp = true;
        propButtonsInit();
    } else if (command == 'refresh') {
        onProp = true;
        propButtonsInit();
    } else if (command == 'delete') {
        onProp = true;
        propButtonsInit();
    }
    return onProp;
}

function selectedCheck() {
    var disableButtons = jq('input.disableButtons').val();
    if(disableButtons == 'true'){
        disableTreeButtons();
    }
    if (getSelectedItemInput() != null &&  disableButtons == 'false') {
        if (getSelectedItemInput().val() != "" && getSelectedItemInput().val() != undefined) {
            enableTreeButtons();
        }
    }
}

function selectedPropCheck() {
    if (getSelectedPropositionInput() != null) {
        if (getSelectedPropositionInput().val() != "" && getSelectedPropositionInput().val() != undefined) {
            enableTreeButtons();
        }
    }
}

function loadControlsInit() {
    if (ENABLED) {
        disablePasteButton();
        propButtonsInit();
    }
}
