<%--
  #%L
  %%
  Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp" %>
<html lang="en">

	<head>
		<title>
			Feedback
		</title>
		<link href="css/screen.css" rel="stylesheet" type="text/css">

    <script language="JavaScript" src="scripts/feedback.js"></script>

	</head>
	<body>

		<table width="100%" border=0 cellpadding=0 cellspacing=0 class="headercell1">
			<tr>
				<td>
					<img src="images/wf-logo.gif" alt="Workflow" width=150 height=21 hspace=5 vspace=5>
				</td>
			</tr>
		</table>

		<br>
		<jsp:include page="WorkflowMessages.jsp" flush="true" />

		<html-el:form action="Feedback.do">

			<kul:csrf />

			<table width="100%" border=0 cellspacing=0 cellpadding=0>
				<tr>
					<td width="20" height="30">
						&nbsp;
					</td>
					<td>
						&nbsp;
					</td>
					<td width="20">
						&nbsp;
					</td>
				</tr>
				<tr>
					<td></td>
					<td>
						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="bord-r-t">

							<!-- fixed-value properties for Falcon contact - not available in Feedback Form -->
							<!-- properties available in Feedback Form -->
							<html-el:hidden name="FeedbackForm" property="timeDate" />
							<html-el:hidden name="FeedbackForm" property="pageUrl" />
							<html-el:hidden name="FeedbackForm" property="exception" />
							<html-el:hidden name="FeedbackForm" property="methodToCall" />
							<html-el:hidden name="FeedbackForm" property="networkId" />
							<html-el:hidden name="FeedbackForm" property="userEmail" />
							<html-el:hidden name="FeedbackForm" property="userName" />

							<tr>
								<td align="right" valign="top" nowrap class="thnormal">
									Name:
								</td>
								<td class="datacell">
								  <c:out value="${FeedbackForm.userName}" default=""/>
      							</td>
  							</tr>

							<tr>
								<td align="right" valign="top" nowrap class="thnormal">
									E-mail:
								</td>
								<td class="datacell">
									<c:out value="${FeedbackForm.userEmail}" default="" />
							    </td>
  							</tr>

							<tr>
								<td align="right" valign="top" nowrap class="thnormal">
									<label for="phone">Phone:</label>
								</td>
								<td class="datacell">
									<html-el:text name="FeedbackForm" property="phone" styleId="phone" title="Phone"/>
								</td>
							</tr>

							<tr>
								<td align="right" valign="top" nowrap class="thnormal">
									<label>Document Id:</label>
								</td>
								<td class="datacell">

									<c:choose>
										<c:when test="${FeedbackForm.documentId != ''}">
											<c:out value="${FeedbackForm.documentId}" />
											<html-el:hidden name="FeedbackForm" property="documentId" />
										</c:when>
            							<c:otherwise>
              								<html-el:text name="FeedbackForm" property="documentId" styleId="documentId" title="Document Id"/>
            							</c:otherwise>
          							</c:choose>
    							</td>
  							</tr>

							<tr>
								<td align="right" valign="top" nowrap class="thnormal">
									<label for="documentType">Document Type:</label>
								</td>
								<td class="datacell">

									<c:choose>
										<c:when test="${FeedbackForm.documentType != ''}">
											<c:out value="${FeedbackForm.documentType}" />
											<html-el:hidden name="FeedbackForm" property="documentType" value="${FeedbackForm.documentType}" />
										</c:when>
									<c:otherwise>
									  <html-el:text name="FeedbackForm" property="documentType" value="" styleId="documentType" title="Document Type" />
									</c:otherwise>
								  </c:choose>
    </td>
  </tr>
  <tr>
    <td align="right" valign="top" nowrap class="thnormal"><label for="category">Category:</label></td>
    <td nowrap class="datacell">
          <html-el:select name="FeedbackForm" property="category" styleId="category" title="Category">
              <html-el:option value="suggestion">Suggestion</html-el:option>
              <html-el:option value="problem">Problem or Technical Question</html-el:option>
          </html-el:select>
    </td>
  </tr>

							<tr>
								<td align="right" valign="top" nowrap class="thnormal">
									<label for="comments">Comments:</label>
								</td>
								<td nowrap class="datacell">
									<html-el:textarea name="FeedbackForm" property="comments" styleId="comments" title="Comments" cols="23" rows="4"/>
								</td>
							</tr>
							<logic-el:present name="FeedbackForm" property="exception">
								<tr>
									<td align="right" valign="top" nowrap class="thnormal">
										<label>Exception:</label>
									</td>
									<td class="datacell">
										<c:out value="${FeedbackForm.exception}" />
									</td>
								</tr>
							</logic-el:present>

							<tr>
								<td class="thnormal" colspan="2" align="center">
									<div align="center">
										<html-el:image property="methodToCall.sendFeedback" src="images/buttonsmall_submit.gif" align="absmiddle" />
										&nbsp;&nbsp;&nbsp;&nbsp;
										<html-el:img src="images/buttonsmall_cancel.gif" align="absmiddle" onclick="javascript:window.close()" />
									</div>
								</td>
							</tr>

						</table>

					</td>
					<td></td>
				</tr>
			</table>

		</html-el:form>

	</body>
</html>


