<#--
 #%L
 %%
 Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#macro uif_list items manager container>

    <#local listType="ul">
    <#if manager.orderedList>
        <#local listType="ol">
    </#if>

    <#if manager.styleClassesAsString?has_content>
        <#local styleClass="class=\"${manager.styleClassesAsString}\""/>
    </#if>

    <#if manager.style?has_content>
        <#local style="style=\"${manager.style}\""/>
    </#if>

    <#local inList=false/>

    <#list items as item>
        <#-- if the item is a header, render outside the list -->
        <#if HelperMethods.isHeader(item.getClass())>
            <#if inList>
                </${listType}>
                <#local inList=false/>
            </#if>

            <@krad.template component=item/>
        <#else>
            <#if !inList>
                <${listType} ${style!} ${styleClass!}>
                <#local inList=true/>
            </#if>

            <#if item.wrapperCssClassesAsString?has_content>
                <#local itemStyleClass="class=\"${item.wrapperCssClassesAsString}\""/>
            <#else>
                <#local itemStyleClass=""/>
            </#if>

            <#if item.wrapperStyle?has_content>
                <#local itemStyle="style=\"${item.wrapperStyle}\""/>
            <#else>
                <#local itemStyle=""/>
            </#if>

            <li ${itemStyle!} ${itemStyleClass!}>
                <@krad.template component=item/>
            </li>
        </#if>
    </#list>

    <#if inList>
        </${listType}>
    </#if>

</#macro>
