<%--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<c:set var="permissionAttributes" value="${DataDictionary.UberPermissionBo.attributes}" />

<kul:tab tabTitle="Permissions" defaultOpen="true" tabErrorKey="document.perm*">
	<div class="tab-container" align="center">    
    <table cellpadding="0" cellspacing="0" summary="">
          <c:if test="${!readOnly}">	
          	
             <tr>
				<td align="center">
	                <div align="center">
	                	<br/>
						<b>Add Permission ID:</b>
             <kul:htmlControlAttribute property="permission.permissionId" attributeEntry="${permissionAttributes.id}"/>
	                	<kul:lookup boClassName="org.kuali.rice.kim.impl.permission.UberPermissionBo"
									fieldConversions="id:permission.permissionId,template.name:permission.permission.template.name,name:permission.permission.name,namespaceCode:permission.permission.namespaceCode"
									anchor="${tabKey}" />
						<html:hidden property="permission.name" />
						<html:hidden property="permission.namespaceCode" />
						${KualiForm.permission.namespaceCode}&nbsp;&nbsp;${KualiForm.permission.name}&nbsp;
	                	<br/>
	                	<br/>
		            </div>
				</td>
			</tr>
			<tr>                                
                <td class="infoline">
					<div align="center">
						<kul:kualiButton property="methodToCall.addPermission.anchor${tabKey}"
									src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
									label="Add" title="Add Permission" styleClass="tinybutton small outline"/>
					</div>
                </td>
	       </tr>         
     </c:if>       
	</table>
	<table cellpadding="0" cellspacing="0" summary="">
        	<tr>
        		<th>&nbsp;</th> 
        		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${permissionAttributes.namespaceCode}" noColon="true" /></div></th>
        		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${permissionAttributes.id}" noColon="true" /></div></th>
        		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${permissionAttributes.name}" noColon="true" /></div></th>
        		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${permissionAttributes.detailObjectsValues}" noColon="true" /></div></th>
        		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${permissionAttributes.active}" noColon="true" /></div></th>
				<c:if test="${!readOnly}">	
            		<kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
				</c:if>	
        	</tr>     
      	<c:forEach var="permission" items="${KualiForm.document.permissions}" varStatus="status">
            <tr>
				<th class="infoline">
					<c:out value="${status.index+1}" />
				</th>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.permissions[${status.index}].permission.namespaceCode"  attributeEntry="${permissionAttributes.namespaceCode}" readOnly="true"  />
					</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.permissions[${status.index}].permissionId"  attributeEntry="${permissionAttributes.id}" readOnly="true"  />
					</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.permissions[${status.index}].permission.name"  attributeEntry="${permissionAttributes.name}" readOnly="true"  />
					</div>
				</td>
	            <td align="left" valign="middle">
	              	<div align="left"> <kul:htmlControlAttribute property="document.permissions[${status.index}].permissionDetailValues"  attributeEntry="${permissionAttributes.detailObjectsValues}" readOnly="true"  />
					</div>
				</td>
				<c:choose>
					<c:when test="${permission.edit && !readOnly}">
			            <td align="center" valign="middle">
			               	<div align="center"> <kul:htmlControlAttribute property="document.permissions[${status.index}].active"  attributeEntry="${permissionAttributes.active}" />
							</div>
						</td>
					</c:when>
       	       		<c:otherwise>
			            <td align="center" valign="middle">
			               	<div align="center"> <kul:htmlControlAttribute property="document.permissions[${status.index}].active"  attributeEntry="${permissionAttributes.active}" readOnly="true"  />
							</div>
						</td>
        	       	</c:otherwise>
       	     	</c:choose>  
			<c:if test="${!readOnly}">	
				<td>
					<div align="center">&nbsp;
                        <kul:kualiButton property="methodToCall.deletePermission.line${status.index}.anchor${currentTabIndex}"
                                         src="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete1.gif"
										 disabledSrc="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete2.gif"
                                         label="Delete" title="Delete Permission" styleClass="tinybutton small outline"
                                         disabled="${permission.edit}" />
					</div>
				</td>
			</c:if>    
			</tr>
		</c:forEach>        
	</table>
	</div>
</kul:tab>
