<#--
 #%L
 %%
 Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#--
    Grid Layout Manager:

      Places each component of the managers field list into a table cell. A new row is created after the
      configured number of columns is rendered.

      The number of horizontal places a field takes up in the grid is determined by the configured colSpan.
      Likewise the number of vertical places a field takes up is determined by the configured rowSpan.

      If the width for the column is not given by the field, it will be calculated by equally dividing the
      space by the number of columns.

      The majority of logic is implemented in grid.tag
 -->

<#macro uif_grid items manager container>

    <#if manager.styleClassesAsString?has_content>
        <#local styleClass="class=\"${manager.styleClassesAsString}\""/>
    </#if>

    <#if manager.style?has_content>
        <#local style="style=\"${manager.style}\""/>
    </#if>

    <table id="${manager.id}" ${style!} ${styleClass!} role="presentation">

        <@krad.grid items=items numberOfColumns=manager.numberOfColumns
                   applyAlternatingRowStyles=manager.applyAlternatingRowStyles
                   applyDefaultCellWidths=manager.applyDefaultCellWidths
                   renderFirstRowHeader=manager.renderFirstRowHeader
                   renderRowFirstCellHeader=manager.renderRowFirstCellHeader
                   renderAlternatingHeaderColumns=manager.renderAlternatingHeaderColumns
                   rowCssClasses=manager.rowCssClasses/>

    </table>

</#macro>
