/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

(function($) {
	$.fn.initPopoutText = function(options){
		return this.each(function(){
			options = options || {};

			//default setting
			options = $.extend({
				label: "",
				summary: "",
				constraint: ""
			}, options);
			
			var id= $(this).attr("id");
			var obj = $(this);

			var context;
            if (top == self || !parent.$) {
                context = jq;
            } else if (parent.$('iframe[id*=easyXDM_]').length > 0) {
                context = parent.$;
            } else if (parent.$('#' + kradVariables.PORTAL_IFRAME_ID).length > 0) {
                context = parent.parent.$;
			}
			
			var labelHtml="";
			var summaryHtml="";
			var constraintHtml="";
			if(options.label){
				labelHtml = "<label for='textarea_popout_control'>"+options.label+"</label>";
			}
			if(options.summary){
				summaryHtml="<span class='summary'>" + options.summary + "</span>";
			}
			if(options.constraint){
				constraintHtml="<span class='constraint'>" + options.constraint + "</span>";
			}
			
			$(this).siblings(".input-group-btn").append('<a id="expand_btn_' + id + '" title="Expand" '
                    + 'class="btn btn-default icon-edit-sign"></a>');
			$(document).ready(function()
			{
				$("a#expand_btn_" + id).click(function(e){
					e.preventDefault();
					
					var value = obj.val();
					if(!value){
						value = "";
					}

                    if (obj[0].disabled === true) {
                        var options = {
                            content: "<div class='textarea_popout'>"+labelHtml+summaryHtml
                                +"<textarea id='textarea_popout_control' readonly>"+value+"</textarea>"
                                +constraintHtml
                                +"<input id='done_btn' class='btn btn-primary done' type='button' value='Done'/></div>",
                            afterShow: function(){
                                context("textarea#textarea_popout_control").focus();
                                context("#done_btn").click(function(e){
                                    e.preventDefault();
                                    obj.val(context("textarea#textarea_popout_control").val());
                                    context.fancybox.close();
                                    obj.valid();
                                    obj.focus();
                                });
                            },
                            autoDimensions: true,
                            hideOnOverlayClick: false,
                            centerOnScroll: true
                        };
                    } else {
                        var options = {
                            content: "<div class='textarea_popout'>"+labelHtml+summaryHtml
                                    +"<textarea id='textarea_popout_control'>"+value+"</textarea>"
                                    +constraintHtml
                                    +"<input id='done_btn' class='btn btn-primary done' type='button' value='Done'/></div>",
                            afterShow: function(){
                                context("textarea#textarea_popout_control").focus();
                                context("#done_btn").click(function(e){
                                    e.preventDefault();
                                    obj.val(context("textarea#textarea_popout_control").val());
                                    context.fancybox.close();
                                    obj.valid();
                                    obj.focus();
                                });
                            },
                            autoDimensions: true,
                            hideOnOverlayClick: false,
                            centerOnScroll: true,
                            padding: 0
                        };
                    }

	        		context.fancybox(options);
				});
			});
		});
	};
})(jQuery);
