/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.selenium;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.kuali.rice.testtools.selenium.WebDriverUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;

public class JenkinsJsonJobResultsBase {
    public static final String BROWSER_DOWNLOAD_DIR = "browser.download.dir";
    public static final String BROWSER_HELPER_APPS_NEVER_ASK_SAVE_TO_DISK = "browser.helperApps.neverAsk.saveToDisk";
    private static final String CAS_USERNAME = "cas.username";
    private static final String CAS_PASSWORD = "cas.password";
    public static final String JENKINS_BASE_URL = "jenkins.base.url";
    public static final String JENKINS_JOBS = "jenkins.jobs";
    public static final String JSON_OUTPUT_DIR = "json.output.dir";
    WebDriver driver;
    boolean passed = false;
    String jenkinsBase;
    String outputDirectory;
    String[] jobsBuildsStrings;
    Map<String, List<String>> jobsBuildsMap = new HashMap<String, List<String>>();
    List<String> jobs = new LinkedList<String>();
    String downloadDir;

    public void setUp() throws MalformedURLException, InterruptedException {
        if (System.getProperty(JENKINS_JOBS) == null) {
            System.out.println("Don't know what jobs to retrieve.  -Djenkins.jobs= must be declared.");
            System.exit(1);
        }
        this.jenkinsBase = System.getProperty(JENKINS_BASE_URL, "http://ci.kuali.org");
        this.outputDirectory = System.getProperty(JSON_OUTPUT_DIR);
        FirefoxProfile profile = new FirefoxProfile();
        profile.setEnableNativeEvents(false);
        this.downloadDir = System.getProperty(BROWSER_DOWNLOAD_DIR, System.getProperty("user.home") + File.separator + "Downloads");
        profile.setPreference("browser.download.folderList", 2);
        profile.setPreference("browser.download.manager.showWhenStarting", false);
        profile.setPreference(BROWSER_DOWNLOAD_DIR, this.downloadDir);
        profile.setPreference(BROWSER_HELPER_APPS_NEVER_ASK_SAVE_TO_DISK, System.getProperty(BROWSER_HELPER_APPS_NEVER_ASK_SAVE_TO_DISK, "application/zip"));
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setCapability("firefox_profile", (Object)profile);
        this.driver = new FirefoxDriver((Capabilities)capabilities);
        this.driver.manage().timeouts().implicitlyWait((long)WebDriverUtils.configuredImplicityWait(), TimeUnit.SECONDS);
        this.driver.get(this.jenkinsBase + "/login?form");
        WebDriverUtils.waitFor((WebDriver)this.driver, (int)WebDriverUtils.configuredImplicityWait(), (By)By.xpath((String)"//span[contains(text(), 'Page generated')]"), (String)this.getClass().toString());
        for (String jobsBuildsString : this.jobsBuildsStrings = System.getProperty(JENKINS_JOBS).split("[,\\s]")) {
            List<Object> jobBuilds;
            if (jobsBuildsString.contains(":")) {
                jobBuilds = Arrays.asList(jobsBuildsString.split(":"));
                String job = (String)jobBuilds.get(0);
                this.jobs.add(job);
                if (jobBuilds.size() == 2 && "all".equals(jobBuilds.get(1))) {
                    this.jobsBuildsMap.put(job, this.fetchAllJobNumbers(job));
                    continue;
                }
                this.jobsBuildsMap.put(job, jobBuilds.subList(1, jobBuilds.size()));
                continue;
            }
            jobBuilds = new LinkedList();
            jobBuilds.add(this.fetchLastCompletedBuildNumber(jobsBuildsString) + "");
            this.jobs.add(jobsBuildsString);
            this.jobsBuildsMap.put(jobsBuildsString, jobBuilds);
        }
        this.passed = true;
    }

    protected String calcOutputFile(String job, String jobNumber) {
        String outputFile = job + "-" + jobNumber + ".json";
        if (this.outputDirectory != null) {
            outputFile = this.outputDirectory + File.separatorChar + outputFile;
        }
        return outputFile;
    }

    protected void closeAndQuitWebDriver() {
        if (this.driver != null) {
            if (WebDriverUtils.dontTearDownPropertyNotSet() && WebDriverUtils.dontTearDownOnFailure((boolean)this.passed)) {
                try {
                    this.driver.close();
                }
                catch (NoSuchWindowException nswe) {
                    System.out.println("NoSuchWindowException closing WebDriver " + nswe.getMessage());
                }
                finally {
                    if (this.driver != null) {
                        this.driver.quit();
                    }
                }
            }
        } else {
            System.out.println("WebDriver is null for " + this.getClass().toString());
        }
    }

    private void exitOnLoginProblems() {
        boolean exit = false;
        String pageSource = this.driver.getPageSource();
        if (pageSource.contains("Username is a required field.")) {
            System.out.println("CAS Username is a required did you set -Dcas.username=");
            exit = true;
        }
        if (pageSource.contains("Password is a required field.")) {
            System.out.println("CAS Password is a required did you set -Dcas.password=");
            exit = true;
        }
        if (pageSource.contains("The credentials you provided cannot be determined to be authentic.")) {
            System.out.println("CAS Login Error");
            exit = true;
        }
        if (exit) {
            System.exit(1);
        }
    }

    protected List<String> fetchAllJobNumbers(String job) {
        LinkedList<String> allJobNumbers = new LinkedList<String>();
        String url = null;
        url = this.jenkinsBase + "/job/" + job + "/api/json";
        try {
            String jobJson = this.retrieveJson(url);
            while (jobJson.contains("{\"number\":")) {
                String jsonJobNumber = jobJson.substring(jobJson.indexOf("{\"number\":") + 10, jobJson.length());
                jsonJobNumber = jsonJobNumber.substring(0, jsonJobNumber.indexOf(","));
                allJobNumbers.add(jsonJobNumber);
                jobJson = jobJson.substring(jobJson.indexOf("{\"number\":") + 9, jobJson.length());
            }
        }
        catch (Exception e) {
            System.err.println("Exception fetching job " + job + " with url " + url + e.getMessage());
        }
        return allJobNumbers;
    }

    protected void fetchArchive(String job, String jobNumber) throws InterruptedException, IOException {
        String archiveUrl = this.jenkinsBase;
        if (job.contains("rice-2.4")) {
            archiveUrl = archiveUrl + "/view/rice-2.4";
        }
        archiveUrl = archiveUrl + "/job/" + job + "/" + jobNumber + "/artifact/*zip*/archive.zip";
        this.driver.get(archiveUrl);
        Thread.sleep(10000L);
        FileUtils.moveFile((File)new File(this.downloadDir + File.separator + "archive.zip"), (File)new File(this.downloadDir + File.separator + job + "-" + jobNumber + ".zip"));
    }

    protected void fetchAndWriteTestReport(String job, String jobNumber) throws InterruptedException, IOException {
        String url = this.jenkinsBase + "/job/" + job + "/" + jobNumber + "/testReport/api/json";
        String json = this.retrieveJson(url);
        String outputFile = this.calcOutputFile(job, jobNumber);
        json = json.replaceAll("}],", "}],\n\n");
        FileUtils.writeStringToFile((File)new File(outputFile), (String)json);
    }

    protected void fetchAndWriteTestReport(String job, String[] jobNumbers) throws InterruptedException, IOException {
        for (String jobNumber : jobNumbers) {
            this.fetchAndWriteTestReport(job, jobNumber);
        }
    }

    protected String fetchLastCompletedBuildNumber(String job) throws InterruptedException {
        String url = this.jenkinsBase + "/job/" + job + "/api/json";
        String jobNumber = null;
        try {
            jobNumber = this.retrieveJson(url);
            jobNumber = jobNumber.substring(jobNumber.indexOf("\"lastCompletedBuild\":{\"number\":") + 31, jobNumber.length());
            jobNumber = jobNumber.substring(0, jobNumber.indexOf(","));
        }
        catch (InterruptedException e) {
            System.err.println("Exception fetching job " + job + " with url " + url + e.getMessage());
            throw e;
        }
        return jobNumber;
    }

    protected String retrieveJson(String url) throws InterruptedException {
        this.driver.get(url);
        Thread.sleep(500L);
        int secondsWaited = 0;
        while (!this.driver.getPageSource().contains("</pre></body></html>") && secondsWaited++ < 2 * WebDriverUtils.configuredImplicityWait()) {
            Thread.sleep(1000L);
        }
        String json = this.driver.getPageSource();
        try {
            json = json.substring(json.indexOf("<pre>") + 5, json.indexOf("</pre></body></html>"));
        }
        catch (IndexOutOfBoundsException iooobe) {
            System.out.println("No JSON results for " + url + " this can be caused by jobs with no test results, from either the test being stopped, aborted or non-test jobs.");
        }
        return json;
    }
}

