/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.common;

import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kuali.rice.testtools.common.JiraAwareFailable;
import org.kuali.rice.testtools.common.PropertiesUtils;

public class JiraAwareFailureUtils {
    public static final String JIRA_BROWSE_URL_PROPERTY = "jira.aware.browse.url";
    private static String JIRA_BROWSE_URL = System.getProperty("jira.aware.browse.url", "https://jira.kuali.org/browse/");
    private static String REGEX_DEFAULT_PROPS_LOCATION = "JiraAwareRegexFailures.properties";
    public static final String REGEX_LOCATION_POPERTY = "jira.aware.regex.failures.location";
    private static String REGEX_PROPS_LOCATION = System.getProperty("jira.aware.regex.failures.location", REGEX_DEFAULT_PROPS_LOCATION);
    private static String CONTAINS_DEFAULT_PROPS_LOCATION = "JiraAwareContainsFailures.properties";
    public static final String CONTAINS_LOCATION_PROERTY = "jira.aware.contains.failures.location";
    private static String CONTAINS_PROPS_LOCATION = System.getProperty("jira.aware.contains.failures.location", CONTAINS_DEFAULT_PROPS_LOCATION);
    static Properties regexJiraMatches;
    static Properties jiraMatches;

    private JiraAwareFailureUtils() {
    }

    public static void fail(String message, JiraAwareFailable failable) {
        JiraAwareFailureUtils.failOnMatchedJira(message, failable);
        failable.fail(message);
    }

    public static void fail(String contents, String message, JiraAwareFailable failable) {
        JiraAwareFailureUtils.failOnMatchedJira(contents, message, failable);
        failable.fail(contents + " " + message);
    }

    public static void fail(String contents, String message, Throwable throwable, JiraAwareFailable failable) {
        JiraAwareFailureUtils.failOnMatchedJira(contents, message, failable);
        if (throwable != null) {
            JiraAwareFailureUtils.failOnMatchedJira(ExceptionUtils.getStackTrace((Throwable)throwable), throwable.getMessage(), failable);
            failable.fail(contents + " " + message + " " + throwable.getMessage() + "\n\t" + ExceptionUtils.getStackTrace((Throwable)throwable));
        }
        failable.fail(message + "\n" + contents);
    }

    public static void failOnMatchedJira(String contents, String message, JiraAwareFailable failable) {
        String match;
        if (message == null) {
            message = "";
        }
        if ((match = JiraAwareFailureUtils.findMatchedJiraContains(message)) != null && !match.equals("")) {
            failable.fail(match);
        }
        if ((match = JiraAwareFailureUtils.findMatchedJiraContains(contents)) != null && !match.equals("")) {
            failable.fail(match);
        }
        if ((match = JiraAwareFailureUtils.findMatchedJiraRegex(message)) != null && !match.equals("")) {
            failable.fail(match);
        }
        if ((match = JiraAwareFailureUtils.findMatchedJiraRegex(contents)) != null && !match.equals("")) {
            failable.fail(match);
        }
    }

    public static void failOnMatchedJira(String contents, JiraAwareFailable failable) {
        String match = JiraAwareFailureUtils.findMatchedJira(contents);
        if (match != null && !match.equals("")) {
            failable.fail(match);
        }
    }

    public static String findMatchedJira(String contents) {
        String match = JiraAwareFailureUtils.findMatchedJiraContains(contents);
        if (match != null && !"".equals(match)) {
            return match;
        }
        return JiraAwareFailureUtils.findMatchedJiraRegex(contents);
    }

    protected static String findMatchedJiraContains(String contents) {
        if (jiraMatches == null || jiraMatches.keySet() == null) {
            System.out.println("WARNING JiraAwareFailureUtils contains properties empty, findMatchesJira contains not available.");
            return "";
        }
        Object var1_1 = null;
        for (String string : jiraMatches.keySet()) {
            if (!contents.contains(string)) continue;
            return "\n" + JIRA_BROWSE_URL + jiraMatches.get(string) + "\n\n" + contents;
        }
        return "";
    }

    protected static String findMatchedJiraRegex(String contents) {
        if (regexJiraMatches == null || regexJiraMatches.keySet() == null) {
            System.out.println("WARNING JiraAwareFailureUtils Regex properties empty, findMatchesJiraRegex not available.");
            return "";
        }
        Object var1_1 = null;
        Pattern pattern = null;
        Matcher matcher = null;
        for (String string : regexJiraMatches.keySet()) {
            pattern = Pattern.compile(string, 32);
            matcher = pattern.matcher(contents);
            if (!matcher.find()) continue;
            return "\n" + JIRA_BROWSE_URL + regexJiraMatches.get(string) + "\n\n" + contents;
        }
        return "";
    }

    static {
        try {
            regexJiraMatches = new PropertiesUtils().loadProperties(REGEX_PROPS_LOCATION, REGEX_DEFAULT_PROPS_LOCATION);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            jiraMatches = new PropertiesUtils().loadProperties(CONTAINS_PROPS_LOCATION, CONTAINS_DEFAULT_PROPS_LOCATION);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

