/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.selenium;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Calendar;
import org.apache.commons.lang.RandomStringUtils;
import org.kuali.rice.testtools.common.JiraAwareFailable;
import org.kuali.rice.testtools.common.JiraAwareFailureUtils;
import org.kuali.rice.testtools.selenium.WebDriverUtils;

public class AutomatedFunctionalTestUtils {
    public static final String DTS = Calendar.getInstance().getTimeInMillis() + "";
    public static final String DTS_TWO = Calendar.getInstance().getTimeInMillis() + "" + RandomStringUtils.randomAlphabetic((int)2).toLowerCase();
    public static final String HIDE_RETURN_LINK = "&hideReturnLink=true";
    public static final String HIDE_RETURN_LINK_FALSE = "&hideReturnLink=false";
    public static final String KRAD_LOOKUP_METHOD = "/kr-krad/lookup?methodToCall=start&dataObjectClassName=";
    public static final String KNS_LOOKUP_METHOD = "/kr/lookup.do?methodToCall=start&businessObjectClassName=";
    public static final String KRAD_PORTAL = "/kr-krad/kradsampleapp?viewId=KradSampleAppHome";
    public static final String KRAD_PORTAL_URL = WebDriverUtils.getBaseUrlString() + "/kr-krad/kradsampleapp?viewId=KradSampleAppHome";
    public static final String LABS = "/kr-krad/labs?viewId=LabsMenuView";
    public static final String LABS_URL = WebDriverUtils.getBaseUrlString() + "/kr-krad/labs?viewId=LabsMenuView";
    public static final String PORTAL = "/portal.do";
    public static final String PORTAL_URL = WebDriverUtils.getBaseUrlString() + "/portal.do";
    public static final String PORTAL_URL_ENCODED = URLEncoder.encode(PORTAL_URL);
    public static final String SHOW_MAINTENANCE_LINKS = "&showMaintenanceLinks=true";
    public static final String REMOTE_UIF_KRAD = "KRAD";
    public static final String REMOTE_UIF_KNS = "KNS";
    public static final String DOC_FORM_KEY = "&docFormKey=";

    public static String createUniqueDtsPlusTwoRandomChars() {
        return Calendar.getInstance().getTimeInMillis() + "" + RandomStringUtils.randomAlphabetic((int)2).toLowerCase();
    }

    public static String createUniqueDtsPlusTwoRandomCharsNot9Digits() {
        String dtsTwo = AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomChars();
        dtsTwo = dtsTwo.substring(0, 5) + dtsTwo.substring(13, 15) + dtsTwo.substring(6, 12);
        return dtsTwo;
    }

    protected static void checkForIncidentReport(String contents, String linkLocator, String message, JiraAwareFailable failable) {
        if (contents == null) {
            return;
        }
        String errorMessage = AutomatedFunctionalTestUtils.incidentReportMessage(contents, linkLocator, message);
        if (errorMessage != null) {
            if (message != null && !message.isEmpty()) {
                failable.jiraAwareFail(errorMessage, message);
            } else {
                failable.jiraAwareFail(errorMessage, contents);
            }
        }
    }

    protected static String incidentReportMessage(String contents, String linkLocator, String message) {
        if (AutomatedFunctionalTestUtils.incidentReported(contents)) {
            try {
                return AutomatedFunctionalTestUtils.processIncidentReport(contents, linkLocator, message);
            }
            catch (IndexOutOfBoundsException e) {
                return "\nIncident report detected " + message + " but there was an exception during processing: " + e.getMessage() + "\nStack Trace from processing exception" + AutomatedFunctionalTestUtils.stackTrace(e) + "\nContents that triggered exception: " + AutomatedFunctionalTestUtils.deLinespace(contents);
            }
        }
        if (contents.contains("HTTP Status 404")) {
            return "HTTP Status 404 contents: " + contents;
        }
        if (contents.contains("HTTP Status 500")) {
            return "\nHTTP Status 500 stacktrace: " + AutomatedFunctionalTestUtils.extract500Exception(contents);
        }
        if (contents.contains("Java backtrace for programmers:") || contents.contains("Java stack trace (for programmers):") || contents.contains("FreeMarker template error:")) {
            try {
                return AutomatedFunctionalTestUtils.freemarkerExceptionMessage(contents, linkLocator, message);
            }
            catch (IndexOutOfBoundsException e) {
                return "\nFreemarker exception detected " + message + " but there was an exception during processing: " + e.getMessage() + "\nStack Trace from processing exception" + AutomatedFunctionalTestUtils.stackTrace(e) + "\nContents that triggered exception: " + AutomatedFunctionalTestUtils.deLinespace(contents);
            }
        }
        if (contents.contains("Document Expired")) {
            return "Document Expired message.";
        }
        return null;
    }

    public static String deLinespace(String contents) {
        while (contents.contains("\n\n")) {
            contents = contents.replaceAll("\n\n", "\n");
        }
        return contents;
    }

    private static String extractIncidentReportInfo(String contents, String linkLocator, String message) {
        String chunk = contents.substring(contents.indexOf("Incident Feedback"), contents.lastIndexOf("</div>"));
        String docId = chunk.substring(chunk.lastIndexOf("Document Id"), chunk.indexOf("View Id"));
        docId = docId.substring(0, docId.indexOf("</div>"));
        docId = docId.substring(docId.lastIndexOf(">") + 2, docId.length()).trim();
        String viewId = chunk.substring(chunk.lastIndexOf("View Id"), chunk.indexOf("Error Message"));
        viewId = viewId.substring(0, viewId.indexOf("</div>"));
        viewId = viewId.substring(viewId.lastIndexOf(">") + 2, viewId.length()).trim();
        String stackTrace = chunk.substring(chunk.lastIndexOf("(only in dev mode)"), chunk.length());
        stackTrace = stackTrace.substring(stackTrace.indexOf("<pre") + 4, stackTrace.length());
        stackTrace = stackTrace.substring(stackTrace.indexOf(">") + 1, stackTrace.indexOf("</"));
        return "\nIncident report " + message + " navigating to " + linkLocator + " : View Id: " + viewId.trim() + " Doc Id: " + docId.trim() + "\nStackTrace: " + stackTrace.trim();
    }

    private static String extractIncidentReportKim(String contents, String linkLocator, String message) {
        if (contents.indexOf("id=\"headerarea\"") > -1) {
            String chunk = contents.substring(contents.indexOf("id=\"headerarea\""), contents.lastIndexOf("</div>"));
            String docIdPre = "type=\"hidden\" value=\"";
            String docId = chunk.substring(chunk.indexOf(docIdPre) + docIdPre.length(), chunk.indexOf("\" name=\"documentId\""));
            String stackTrace = chunk.substring(chunk.lastIndexOf("name=\"displayMessage\""), chunk.length());
            String stackTracePre = "value=\"";
            stackTrace = stackTrace.substring(stackTrace.indexOf(stackTracePre) + stackTracePre.length(), stackTrace.indexOf("name=\"stackTrace\"") - 2);
            return "\nIncident report " + message + " navigating to " + linkLocator + " Doc Id: " + docId.trim() + "\nStackTrace: " + stackTrace.trim();
        }
        return "\nIncident report detected for " + linkLocator + " but not able to parse.  " + message;
    }

    public static void failOnInvalidUserName(String userName, String contents, JiraAwareFailable failable) {
        if (contents.indexOf("Invalid") > -1) {
            failable.fail("Invalid Login " + userName);
        }
    }

    private static void failWithInfo(String contents, String linkLocator, JiraAwareFailable failable, String message) {
        JiraAwareFailureUtils.failOnMatchedJira(contents, linkLocator, failable);
        failable.fail(contents);
    }

    private static void failWithReportInfo(String contents, String linkLocator, JiraAwareFailable failable, String message) {
        String incidentReportInformation = AutomatedFunctionalTestUtils.extractIncidentReportInfo(contents, linkLocator, message);
        JiraAwareFailureUtils.failOnMatchedJira(incidentReportInformation, failable);
        AutomatedFunctionalTestUtils.failWithInfo(incidentReportInformation, linkLocator, failable, message);
    }

    private static void failWithReportInfoForKim(String contents, String linkLocator, JiraAwareFailable failable, String message) {
        String kimIncidentReport = AutomatedFunctionalTestUtils.extractIncidentReportKim(contents, linkLocator, message);
        JiraAwareFailureUtils.failOnMatchedJira(kimIncidentReport, failable);
        failable.fail(kimIncidentReport);
    }

    public static String getHTML(String urlToRead) {
        String result = "";
        try {
            String line;
            URL url = new URL(urlToRead);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result = result + line;
            }
            rd.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static boolean incidentReported(String contents) {
        return contents != null && contents.contains("Incident Report") && !contents.contains("portal.do?channelTitle=Incident%20Report") && !contents.contains("portal.do?channelTitle=Incident Report") && !contents.contains("uitest?viewId=Travel-testView2") && !contents.contains("SeleniumException");
    }

    public static String prettyHttp(String baseUrl) {
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        if (!baseUrl.startsWith("http")) {
            baseUrl = "http://" + baseUrl;
        }
        return baseUrl;
    }

    private static String extract500Exception(String contents) {
        return contents.substring(contents.indexOf("<b>exception</b> </p><pre>") + 26, contents.indexOf("</pre><p></p><p><b>note</b>"));
    }

    private static void processFreemarkerException(String contents, String linkLocator, JiraAwareFailable failable, String message) {
        JiraAwareFailureUtils.failOnMatchedJira(contents, failable);
        String errorMessage = AutomatedFunctionalTestUtils.freemarkerExceptionMessage(contents, linkLocator, message);
        JiraAwareFailureUtils.failOnMatchedJira(errorMessage, linkLocator, failable);
        failable.fail(errorMessage);
    }

    protected static String freemarkerExceptionMessage(String contents, String linkLocator, String message) {
        String ftlStackTrace = null;
        if (contents.contains("more<")) {
            ftlStackTrace = contents.substring(contents.indexOf("----------"), contents.indexOf("more<") - 1);
        } else if (contents.contains("at java.lang.Thread.run(Thread.java:")) {
            ftlStackTrace = contents.indexOf("Error: on line") > -1 ? contents.substring(contents.indexOf("Error: on line"), contents.indexOf("at java.lang.Thread.run(Thread.java:") + 39) : contents.substring(contents.indexOf("FreeMarker template error:"), contents.indexOf("at java.lang.Thread.run(Thread.java:") + 39);
        }
        return "\nFreemarker Exception " + message + " navigating to " + linkLocator + "\nStackTrace: " + ftlStackTrace.trim();
    }

    protected static void processIncidentReport(String contents, String linkLocator, JiraAwareFailable failable, String message) {
        if (contents.indexOf("Incident Feedback") > -1) {
            AutomatedFunctionalTestUtils.failWithReportInfo(contents, linkLocator, failable, message);
        }
        if (contents.indexOf("Incident Report") > -1) {
            AutomatedFunctionalTestUtils.failWithReportInfoForKim(contents, linkLocator, failable, message);
        }
        JiraAwareFailureUtils.failOnMatchedJira(contents, failable);
        failable.fail("\nIncident report detected " + message + "\n Unable to parse out details for the contents that triggered exception: " + AutomatedFunctionalTestUtils.deLinespace(contents));
    }

    protected static String processIncidentReport(String contents, String linkLocator, String message) {
        if (contents.indexOf("Incident Feedback") > -1) {
            return AutomatedFunctionalTestUtils.extractIncidentReportInfo(contents, linkLocator, message);
        }
        if (contents.indexOf("Incident Report") > -1) {
            return AutomatedFunctionalTestUtils.extractIncidentReportKim(contents, linkLocator, message);
        }
        return "\nIncident report detected " + message + "\n Unable to parse out details for the contents that triggered exception: " + AutomatedFunctionalTestUtils.deLinespace(contents);
    }

    public static String stackTrace(Throwable throwable) {
        StringWriter wrt = new StringWriter();
        PrintWriter pw = new PrintWriter(wrt);
        throwable.printStackTrace(pw);
        pw.flush();
        return wrt.toString();
    }

    public static boolean isKradLogin() {
        String loginUif = System.getProperty("remote.login.uif");
        if (loginUif == null) {
            loginUif = REMOTE_UIF_KRAD;
        }
        return REMOTE_UIF_KRAD.equalsIgnoreCase(loginUif);
    }
}

