/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.selenium;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.kuali.rice.testtools.common.JiraAwareFailable;
import org.kuali.rice.testtools.common.JiraAwareFailureUtils;
import org.kuali.rice.testtools.selenium.AutomatedFunctionalTestUtils;
import org.kuali.rice.testtools.selenium.JiraAwareAftBase;
import org.kuali.rice.testtools.selenium.WebDriverScreenshotHelper;
import org.kuali.rice.testtools.selenium.WebDriverUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebDriver;

public abstract class WebDriverAftBase
extends JiraAwareAftBase {
    protected static ChromeDriverService chromeDriverService;
    public static final String DATA_TABLE_TH_CSS = "div.dataTables_wrapper thead th";
    protected WebDriver driver;
    protected String jGrowlHeader;
    public static final String LOOKUP_CRITERIA_NUMBER_NAME = "lookupCriteria[number]";
    public static final String REGEX_ERROR = "^[\\s\\S]*error[\\s\\S]*$";
    public static final String REGEX_VALID = "^[\\s\\S]*valid[\\s\\S]*$";
    public static final String RETURN_SELECTED_BUTTON_TEXT = "return selected";
    public static final String RETURN_VALUE_LINK_TEXT = "return value";
    public static final String SEARCH_XPATH_3 = "//button[contains(text(),'earch')]";
    public static final String SHOW_INACTIVE = "show inactive";
    public static final String SUB_COLLECTION_UIF_DISCLOSURE_SPAN_UIF_HEADER_TEXT_SPAN_XPATH = "div.uif-group.uif-collectionGroup.uif-tableCollectionGroup.uif-tableSubCollection.uif-disclosure span.uif-headerText-span";
    protected String sessionId = null;
    protected String testMethodName;
    @Rule
    public TestName testName = new TestName();
    public static final String TIMEOUT_MESSAGE = "timeout";
    protected String uniqueString;
    protected String user = "admin";
    protected int waitSeconds;
    protected WebDriverScreenshotHelper webDriverScreenshotHelper = new WebDriverScreenshotHelper();

    protected void acceptAlertIfPresent() {
        WebDriverUtils.acceptAlertIfPresent(this.driver);
    }

    protected void alertAccept() {
        WebDriverUtils.alertAccept(this.driver);
    }

    protected void alertDismiss() {
        WebDriverUtils.alertDismiss(this.driver);
    }

    @AfterClass
    public static void afterClass() {
        if (chromeDriverService != null) {
            chromeDriverService.stop();
        }
    }

    protected boolean areAllMultiValueSelectsChecked() throws InterruptedException {
        this.acceptAlertIfPresent();
        WebElement tbody = this.waitAndGetElementByAttributeValue("role", "alert");
        List<WebElement> checkboxes = this.findElements(By.className((String)"uif-checkboxControl"), tbody);
        for (WebElement checkbox : checkboxes) {
            if ("true".equals(checkbox.getAttribute("checked"))) continue;
            return false;
        }
        return true;
    }

    protected boolean areNoMultiValueSelectsChecked() throws InterruptedException {
        WebElement tbody = this.waitAndGetElementByAttributeValue("role", "alert");
        List<WebElement> checkboxes = this.findElements(By.className((String)"uif-checkboxControl"), tbody);
        for (WebElement checkbox : checkboxes) {
            if (null == checkbox.getAttribute("checked")) continue;
            return false;
        }
        return true;
    }

    protected void assertAttributeClassRegexDoesntMatch(String field, String regex) throws InterruptedException {
        Thread.sleep(1000L);
        String attribute = this.waitAndGetAttributeByName(field, "class");
        this.assertTrue("waitAndGetAttributeByName(" + field + ", \"class\") should not be null", attribute != null);
        this.assertFalse("attribute " + attribute + " matches regex " + regex + " and it should not", attribute.matches(regex));
    }

    protected void assertAttributeClassRegexMatches(String field, String regex) throws InterruptedException {
        Thread.sleep(1000L);
        String attribute = this.waitAndGetAttributeByName(field, "class");
        this.assertTrue("waitAndGetAttributeByName(" + field + ", \"class\") should not be null", attribute != null);
        this.assertTrue("attribute " + attribute + " doesn't match regex " + regex, attribute.matches(regex));
    }

    protected void assertElementPresentInResultPages(By searchBy) throws Exception {
        while (!this.isElementPresent(searchBy)) {
            this.assertTrue("Didn't find expected results in result pages", this.isNextLinkEnabled());
            this.waitAndClickByLinkText("Next");
        }
    }

    protected void assertElementsPresentInResultPages(By[] searchBys) throws Exception {
        boolean[] founds = new boolean[searchBys.length];
        boolean allFound = false;
        this.waitForElementPresentById("uLookupResults_layout_next");
        while (!allFound) {
            int i;
            for (i = 0; i < founds.length; ++i) {
                if (founds[i]) continue;
                founds[i] = this.isElementPresent(searchBys[i]);
            }
            allFound = true;
            for (i = 0; i < founds.length; ++i) {
                if (founds[i]) continue;
                allFound = false;
            }
            if (allFound) continue;
            this.assertTrue("Didn't find expected results in result pages for " + this.getClass().getSimpleName(), this.isNextLinkEnabled());
            this.waitAndClickByLinkText("Next");
        }
    }

    protected void assertTextPresentInResultPages(String[][] texts) throws Exception {
        boolean[] founds = new boolean[texts.length];
        boolean allFound = false;
        this.waitForElementPresentById("uLookupResults_layout_next");
        while (!allFound) {
            int i;
            for (i = 0; i < founds.length; ++i) {
                if (founds[i]) continue;
                for (int j = 0; j < texts.length; ++j) {
                    founds[i] = this.isTextPresent(texts[i]);
                }
            }
            allFound = true;
            for (i = 0; i < founds.length; ++i) {
                if (founds[i]) continue;
                allFound = false;
            }
            if (allFound) continue;
            this.assertTrue("Didn't find expected results in result pages for " + this.getClass().getSimpleName(), this.isNextLinkEnabled());
            this.waitAndClickByLinkText("Next");
        }
    }

    protected void assertEmptyInputByName(String name) throws InterruptedException {
        this.assertTrue(name + " not empty for " + this.getClass().getSimpleName(), this.waitForElementPresentByName(name).getAttribute("value").equals(""));
    }

    protected void assertFocusTypeBlurError(String field, String textToType) throws InterruptedException {
        this.fireEvent(field, "focus");
        this.waitAndTypeByName(field, textToType);
        this.fireEvent(field, "blur");
        Thread.sleep(500L);
        this.assertAttributeClassRegexMatches(field, REGEX_ERROR);
        this.clearTextByName(field);
    }

    protected void assertFocusTypeBlurError(String field, String[] errorInputs) throws InterruptedException {
        for (String errorInput : errorInputs) {
            this.assertFocusTypeBlurError(field, errorInput);
            this.clearTextByName(field);
        }
    }

    protected void assertFocusTypeBlurValid(String field, String textToType) throws InterruptedException {
        this.clearTextByName(field);
        this.fireEvent(field, "focus");
        this.waitAndTypeByName(field, textToType);
        this.fireEvent(field, "blur");
        Thread.sleep(200L);
        this.assertAttributeClassRegexMatches(field, REGEX_VALID);
        this.assertAttributeClassRegexDoesntMatch(field, REGEX_ERROR);
        this.clearTextByName(field);
    }

    protected void assertFocusTypeBlurValid(String field, String[] validInputs) throws InterruptedException {
        for (String validInput : validInputs) {
            this.assertFocusTypeBlurValid(field, validInput);
            this.clearTextByName(field);
        }
    }

    protected void assertFocusTypeBlurValidation(String field, String[] errorInputs, String[] validInputs) throws InterruptedException {
        this.assertFocusTypeBlurError(field, errorInputs);
        this.clearTextByName(field);
        this.assertFocusTypeBlurValid(field, validInputs);
    }

    protected void assertFocusTypeTabError(String field, String textToType) throws InterruptedException {
        this.fireEvent(field, "focus");
        this.waitAndTypeByName(field, textToType);
        this.driver.switchTo().activeElement().sendKeys(new CharSequence[]{Keys.TAB});
        Thread.sleep(500L);
        this.assertAttributeClassRegexMatches(field, REGEX_ERROR);
        this.clearTextByName(field);
    }

    protected void assertJgrowlText(String jGrowlText) throws InterruptedException {
        this.waitForElementPresentByClassName("jGrowl-message");
        while (this.jGrowlTextContains("Unable to load SWF file")) {
            try {
                this.driver.findElement(By.className((String)"jGrowl-close")).click();
            }
            catch (Throwable throwable) {}
        }
        StringBuilder sb = new StringBuilder("");
        List<WebElement> jGrowls = this.findElements(By.className((String)"jGrowl-message"));
        for (WebElement jGrowl : jGrowls) {
            if (jGrowl.getText() == null) continue;
            sb.append(jGrowl.getText()).append("\n");
        }
        String growlText = sb.toString();
        WebDriverUtils.stepMessage("Do jGrowls contain text '" + jGrowlText + "'? " + growlText.contains(jGrowlText));
        this.assertTrue(growlText + " does not contain " + jGrowlText, growlText.contains(jGrowlText));
    }

    private boolean jGrowlTextContains(String text) {
        boolean contains = false;
        try {
            contains = this.findElement(By.className((String)"jGrowl-message")).getText().contains(text);
        }
        catch (Throwable t) {
            return false;
        }
        return contains;
    }

    protected void assertLabelWithTextPresent(String labelText) throws InterruptedException {
        this.jGrowl("Assert Label containing the text " + labelText + " is present");
        this.waitForElementPresentByXpath("//label[contains(text(), '" + labelText + "')]");
    }

    protected void assertLabelFor(String forElementId, String labelText) {
        this.assertEquals(labelText, this.getForLabelText(forElementId));
    }

    protected void assertMultiValueDeselectAllThisPage() throws InterruptedException {
        this.waitAndClickDropDown("deselect all items on this page");
        if (!this.areNoMultiValueSelectsChecked()) {
            this.jiraAwareFail("deselect all items on this page failure");
        }
        this.assertButtonDisabledByText(RETURN_SELECTED_BUTTON_TEXT);
    }

    protected void assertMultiValueSelectAllThisPage() throws InterruptedException {
        this.waitAndClickDropDown("select all items on this page");
        if (!this.areAllMultiValueSelectsChecked()) {
            JiraAwareFailureUtils.fail("select all items on this page failure", this);
        }
        this.assertButtonEnabledByText(RETURN_SELECTED_BUTTON_TEXT);
    }

    protected void assertTextPresent(String[] text) throws InterruptedException {
        this.assertTextPresent("", text);
    }

    protected void assertTextPresent(String message, String[] text) throws InterruptedException {
        StringBuilder missingText = new StringBuilder("");
        boolean present = true;
        int s = text.length;
        for (int i = 0; i < s; ++i) {
            if (i == 0) {
                present = this.waitForIsTextPresent(text[0]);
                if (present) continue;
                missingText.append(text[0]);
                continue;
            }
            if (this.isTextPresent(text[i]).booleanValue()) continue;
            present = false;
            missingText.append(" " + text[i]);
        }
        if (!present) {
            this.jiraAwareFail(message + " " + missingText + " not present for " + this.getClass().toString());
        }
    }

    protected void assertTextPresent(String[][] text) throws InterruptedException {
        StringBuilder missingText = new StringBuilder("");
        boolean present = true;
        int s = text.length;
        for (int i = 0; i < s; ++i) {
            int t = text[i].length;
            for (int j = 0; j < t; ++j) {
                if (i == 0 && j == 0) {
                    present = this.waitForIsTextPresent(text[0][0]);
                    if (present) continue;
                    missingText.append(text[0][0]);
                    continue;
                }
                if (this.isTextPresent(text[i][j]).booleanValue()) continue;
                present = false;
                missingText.append(" " + text[i][j]);
            }
        }
        if (!present) {
            this.jiraAwareFail(missingText + " not present for " + this.getClass().toString());
        }
    }

    protected void assertPopUpWindowUrl(By by, String windowName, String url) {
        this.findElement(by).click();
        String parentWindowHandle = this.driver.getWindowHandle();
        this.driver.switchTo().window(windowName).findElements(By.tagName((String)"head"));
        this.assertEquals(url, this.driver.getCurrentUrl());
        this.driver.switchTo().window(parentWindowHandle);
    }

    protected void back() {
        this.jGrowl("Click browser back button");
        this.driver.navigate().back();
    }

    protected void check(By by) throws InterruptedException {
        WebElement element = this.findElement(by);
        if (!element.isSelected()) {
            element.click();
        }
    }

    protected void checkById(String id) throws InterruptedException {
        this.check(By.id((String)id));
    }

    protected void checkByName(String name) throws InterruptedException {
        this.check(By.name((String)name));
    }

    protected void checkByXpath(String locator) throws InterruptedException {
        this.check(By.xpath((String)locator));
    }

    protected void checkForIncidentReport() {
        this.checkForIncidentReport("", this.getClass().toString());
    }

    protected String incidentReportMessage() {
        return AutomatedFunctionalTestUtils.incidentReportMessage(this.driver.getPageSource(), "", this.getClass().toString());
    }

    protected void checkForIncidentReport(String locator) {
        this.checkForIncidentReport(locator, this.getClass().toString());
    }

    @Override
    protected void checkForIncidentReport(String locator, String message) {
        AutomatedFunctionalTestUtils.checkForIncidentReport(this.driver.getPageSource(), locator, message, this);
    }

    protected void checkForIncidentReport(String locator, JiraAwareFailable failable, String message) {
        AutomatedFunctionalTestUtils.checkForIncidentReport(this.driver.getPageSource(), locator, message, failable);
    }

    protected void clearText(By by) throws InterruptedException {
        this.findElement(by).clear();
    }

    protected void clearText(String selector) throws InterruptedException {
        this.clearText(By.cssSelector((String)selector));
    }

    protected void clearTextByName(String name) throws InterruptedException {
        this.clearText(By.name((String)name));
    }

    protected void clearTextByXpath(String locator) throws InterruptedException {
        this.clearText(By.xpath((String)locator));
    }

    protected void close() {
        this.driver.close();
    }

    protected void closeAllOtherWindows(String handleToKeep) {
        Set set = this.driver.getWindowHandles();
        set.remove(handleToKeep);
        Iterator iter = set.iterator();
        String handle = "";
        while (iter.hasNext()) {
            handle = (String)iter.next();
            this.driver.switchTo().window(handle);
            this.driver.close();
        }
        this.driver.switchTo().window(handleToKeep);
    }

    protected void colapseExpandByXpath(String clickLocator, String visibleLocator) throws InterruptedException {
        this.waitAndClickByXpath(clickLocator);
        this.waitNotVisibleByXpath(visibleLocator);
        this.waitAndClickByXpath(clickLocator);
        this.waitIsVisibleByXpath(visibleLocator);
    }

    @BeforeClass
    public static void chromeDriverService() throws Exception {
        chromeDriverService = WebDriverUtils.chromeDriverCreateCheck();
        if (chromeDriverService != null) {
            chromeDriverService.start();
        }
    }

    protected void closeAndQuitWebDriver() {
        if (this.driver != null) {
            if (WebDriverUtils.dontTearDownPropertyNotSet() && WebDriverUtils.dontTearDownOnFailure(this.isPassed())) {
                try {
                    this.acceptAlertIfPresent();
                    this.driver.close();
                }
                catch (NoSuchWindowException nswe) {
                    System.out.println("NoSuchWindowException closing WebDriver " + nswe.getMessage());
                }
                finally {
                    if (this.driver != null) {
                        this.driver.quit();
                    }
                }
            }
        } else {
            System.out.println("WebDriver is null for " + this.getClass().toString() + " if using a remote hub did you include the port?");
        }
    }

    protected void determineImplicitWait() {
        this.waitSeconds = WebDriverUtils.configuredImplicityWait();
    }

    protected void determineJgrowlHeader() {
        this.jGrowlHeader = this.getClass().getSimpleName() + "." + this.testMethodName;
    }

    protected String determinePage() {
        String url = this.driver.getCurrentUrl();
        String viewId = "";
        if (url.contains("viewId=")) {
            viewId = url.substring(url.indexOf("viewId=") + 7, url.length());
            viewId = viewId.indexOf("&") > -1 ? viewId.substring(0, viewId.indexOf("&")) : viewId.substring(0, viewId.length());
        }
        String pageId = "";
        if (url.contains("pageId=")) {
            pageId = url.substring(url.indexOf("pageId=") + 7, url.length());
            pageId = pageId.indexOf("&") > -1 ? "-" + pageId.substring(0, pageId.indexOf("&")) : "-" + pageId.substring(0, pageId.length());
        }
        return viewId + pageId;
    }

    protected void determineTestMethodName() {
        if (this.testName != null && this.testName.getMethodName() != null) {
            this.setTestMethodName(this.testName.getMethodName());
        }
    }

    public void setTestMethodName(String testMethodName) {
        this.testMethodName = testMethodName;
    }

    protected void determineUser() {
        String givenUser = WebDriverUtils.determineUser(this.toString());
        if (givenUser != null) {
            this.user = givenUser;
        }
    }

    protected String getDescriptionBase() {
        return this.getClass().toString().substring(this.getClass().toString().lastIndexOf(".") + 1, this.getClass().toString().length()) + "." + this.testMethodName + " description";
    }

    protected String getDescriptionUnique() {
        if (this.uniqueString == null) {
            this.uniqueString = AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomCharsNot9Digits();
        }
        return this.getDescriptionBase() + " " + this.uniqueString;
    }

    protected WebElement findButtonByText(String buttonText) {
        return WebDriverUtils.findButtonByText(this.driver, buttonText);
    }

    protected List<WebElement> findVisibleElements(By by) {
        List webElements = this.driver.findElements(by);
        LinkedList<WebElement> visibleWebElements = new LinkedList<WebElement>();
        for (WebElement webElement : webElements) {
            if (!webElement.isDisplayed()) continue;
            visibleWebElements.add(webElement);
        }
        return visibleWebElements;
    }

    protected List<WebElement> findElements(By by) {
        List found = this.driver.findElements(by);
        return found;
    }

    protected List<WebElement> findElements(By by, WebElement element) {
        if (element == null) {
            this.checkForIncidentReport();
            throw new AssertionError((Object)("element to findElements on for " + by.toString() + " is null in class " + this.getClass().toString()));
        }
        List found = element.findElements(by);
        return found;
    }

    protected void fireEvent(String name, String event) {
        ((JavascriptExecutor)this.driver).executeScript("var elements=document.getElementsByName(\"" + name + "\");" + "for (var i = 0; i < elements.length; i++){" + "elements[i]." + event + "();}", new Object[0]);
    }

    protected void fireEvent(String name, String value, String event) {
        ((JavascriptExecutor)this.driver).executeScript("var elements=document.getElementsByName(\"" + name + "\");" + "for (var i = 0; i < elements.length; i++){" + "if(elements[i].value=='" + value + "')" + "elements[i]." + event + "();}", new Object[0]);
    }

    public void fireMouseOverEventByName(String name) {
        this.fireMouseOverEvent(By.name((String)name));
    }

    public void fireMouseOverEventById(String id) {
        this.fireMouseOverEvent(By.id((String)id));
    }

    public void fireMouseOverEventByXpath(String locator) {
        this.fireMouseOverEvent(By.xpath((String)locator));
    }

    public void fireMouseOverEvent(By by) {
        Actions builder = new Actions(this.driver);
        Actions hover = builder.moveToElement(this.findElement(by));
        hover.perform();
    }

    public String[] getAllWindowTitles() {
        return (String[])this.driver.getWindowHandles().toArray();
    }

    protected String getBaseUrlString() {
        return WebDriverUtils.getBaseUrlString();
    }

    protected int getCssCount(String selector) {
        return this.getCssCount(By.cssSelector((String)selector));
    }

    protected int getCssCount(By by) {
        return this.findElements(by).size();
    }

    protected String getDateTimeStampFormatted() {
        return WebDriverUtils.getDateTimeStampFormatted();
    }

    protected String getDateToday() {
        Date now = Calendar.getInstance().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        return sdf.format(now);
    }

    protected String getDateTomorrow() {
        Calendar now = Calendar.getInstance();
        now.add(5, 1);
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        return sdf.format(now.getTime());
    }

    @Override
    protected WebDriver getDriver() {
        return this.driver;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    protected WebElement getElementByAttribute(String attributeName) {
        return this.findElement(By.cssSelector((String)("[" + attributeName + "]")));
    }

    protected WebElement getElementByDataAttribute(String dataAttributeName) {
        return this.findElement(By.cssSelector((String)("[data-" + dataAttributeName + "]")));
    }

    protected WebElement getElementByDataAttributeValue(String dataAttributeName, String value) {
        return this.findElement(By.cssSelector((String)("[data-" + dataAttributeName + "='" + value + "']")));
    }

    protected WebElement getElementByAttributeValue(String attributeName, String value) {
        return this.findElement(By.cssSelector((String)("[" + attributeName + "='" + value + "']")));
    }

    protected List<WebElement> getElementsByAttributeValue(String attributeName, String value) {
        return this.findElements(By.cssSelector((String)("[" + attributeName + "='" + value + "']")));
    }

    @Override
    protected String getNavigationUrl() {
        String classString = this.getClass().toString();
        if (classString.contains("krad.demo")) {
            return "/kr-krad/kradsampleapp?viewId=KradSampleAppHome";
        }
        if (classString.contains("krad.labs")) {
            return "/kr-krad/labs?viewId=LabsMenuView";
        }
        return "/portal.do";
    }

    protected String[] getSelectOptions(By by) throws InterruptedException {
        WebElement select1 = this.driver.findElement(by);
        List options = select1.findElements(By.tagName((String)"option"));
        String[] optionValues = new String[options.size()];
        int counter = 0;
        for (WebElement option : options) {
            optionValues[counter] = option.getAttribute("value");
            ++counter;
        }
        return optionValues;
    }

    protected String[] getSelectOptionsByName(String name) throws InterruptedException {
        return this.getSelectOptions(By.name((String)name));
    }

    protected String[] getSelectOptionsByXpath(String locator) throws InterruptedException {
        return this.getSelectOptions(By.xpath((String)locator));
    }

    public String getSessionId() {
        return this.sessionId;
    }

    protected String getText(By by) throws InterruptedException {
        WebElement element = this.findElement(by);
        return element.getText();
    }

    protected String getTextByClassName(String className) throws InterruptedException {
        return this.getText(By.className((String)className));
    }

    protected String getTextById(String id) throws InterruptedException {
        return this.getText(By.id((String)id));
    }

    protected String getTextByName(String name) throws InterruptedException {
        return this.getText(By.name((String)name));
    }

    protected String getText(String locator) throws InterruptedException {
        return this.getText(By.cssSelector((String)locator));
    }

    protected String getTextByXpath(String locator) throws InterruptedException {
        return this.getText(By.xpath((String)locator));
    }

    protected String getTitle() {
        return this.driver.getTitle();
    }

    public String getUserName() {
        return this.user;
    }

    protected String getForLabelText(String forElementId) {
        return this.findElement(By.cssSelector((String)("label[for=" + forElementId + "]"))).getText();
    }

    protected void gotoIframeById(String iframeId) {
        if (this.driver.findElements(By.id((String)iframeId)).size() > 0) {
            WebElement contentFrame = this.driver.findElement(By.id((String)iframeId));
            this.driver.switchTo().frame(contentFrame);
        } else {
            System.out.println("Unable to find " + iframeId);
        }
    }

    protected WebElement gotoIframeByXpath(String iframeXpath) {
        if (this.driver.findElements(By.xpath((String)iframeXpath)).size() > 0) {
            WebElement contentFrame = this.driver.findElement(By.xpath((String)iframeXpath));
            this.driver.switchTo().frame(contentFrame);
            return contentFrame;
        }
        System.out.println("Unable to find " + iframeXpath);
        return null;
    }

    protected void gotoLightBox() throws InterruptedException {
        this.waitForElementVisibleBy(By.cssSelector((String)".uif-lookupDialog-iframe"));
        this.driver.switchTo().frame(this.driver.findElement(By.cssSelector((String)".uif-lookupDialog-iframe")));
    }

    protected WebElement gotoLightBoxIframe() {
        this.selectTopFrame();
        return this.gotoIframeByXpath("//iframe[@class='uif-iFrame uif-lookupDialog-iframe']");
    }

    protected int howManyAreVisible(By by) throws InterruptedException {
        int count = 0;
        if (by == null) {
            return count;
        }
        List webElementsFound = this.driver.findElements(by);
        for (WebElement webElement : webElementsFound) {
            if (!webElement.isDisplayed()) continue;
            ++count;
        }
        return count;
    }

    protected boolean isNextLinkEnabled() {
        return this.findElements(By.xpath((String)"//a[@id='uLookupResults_layout_next' and @class='next paginate_button paginate_button_disabled']")).size() != 1;
    }

    protected boolean isChecked(By by) {
        return this.findElement(by).isSelected();
    }

    protected boolean isCheckedById(String id) {
        return this.isChecked(By.id((String)id));
    }

    protected boolean isCheckedByName(String name) {
        return this.isChecked(By.name((String)name));
    }

    protected boolean isCheckedByXpath(String locator) {
        return this.isChecked(By.xpath((String)locator));
    }

    protected boolean isEnabled(By by) {
        return this.findElement(by).isEnabled();
    }

    protected boolean isEnabledById(String id) {
        return this.isEnabled(By.id((String)id));
    }

    protected boolean isEnabledByName(String name) {
        return this.isEnabled(By.name((String)name));
    }

    protected boolean isEnabledByXpath(String locator) {
        return this.isEnabled(By.xpath((String)locator));
    }

    protected boolean isVisible(By[] bys) {
        if (bys == null || bys.length == 0) {
            return false;
        }
        int s = bys.length;
        for (int i = 0; i < s; ++i) {
            try {
                if (!this.isVisible(bys[i])) continue;
                return true;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean isElementPresent(By by) {
        return this.driver.findElements(by).size() > 0;
    }

    protected boolean isElementPresent(String locator) {
        return this.driver.findElements(By.cssSelector((String)locator)).size() > 0;
    }

    protected boolean isElementPresentById(String id) {
        return this.isElementPresent(By.id((String)id));
    }

    protected boolean isElementPresentByName(String name) {
        return this.isElementPresent(By.name((String)name));
    }

    protected boolean isElementPresentByXpath(String locator) {
        return this.isElementPresent(By.xpath((String)locator));
    }

    protected boolean isElementPresentByLinkText(String locator) {
        return this.isElementPresent(By.linkText((String)locator));
    }

    protected boolean isElementPresentByDataAttributeValue(String dataAttributeName, String dataAttributeValue) {
        return this.isElementPresent(By.cssSelector((String)("[data-" + dataAttributeName + "='" + dataAttributeValue + "']")));
    }

    protected boolean isNotVisible(By by) {
        return !this.isVisible(by);
    }

    protected Boolean isTextPresent(String text) {
        return WebDriverUtils.isTextPresent(this.driver, this.driver.getPageSource(), text);
    }

    protected Boolean isTextPresent(String[] texts) {
        String pageSource = this.driver.getPageSource();
        for (String text : texts) {
            if (WebDriverUtils.isTextPresent(this.driver, pageSource, text).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected void javascriptErrorsReport() {
        List javascriptErrors = WebDriverUtils.javascriptErrors(this.getDriver());
        if (javascriptErrors != null && javascriptErrors.size() > 0) {
            this.jGrowl("JAVASCRIPT ERRORS DETECTED - " + WebDriverUtils.javascriptErrorsToString(javascriptErrors));
        }
    }

    protected void jGrowl(String message) {
        WebDriverUtils.jGrowl(this.driver, this.jGrowlHeader, false, message);
        if (this.webDriverScreenshotHelper.screenshotSteps()) {
            this.screenshot();
        }
    }

    protected void jGrowlSticky(String message) {
        WebDriverUtils.jGrowl(this.driver, this.jGrowlHeader, true, message);
        if (this.webDriverScreenshotHelper.screenshotSteps()) {
            this.screenshot();
        }
    }

    public void login(WebDriver driver, String userName, JiraAwareFailable failable) throws InterruptedException {
        if ("true".equalsIgnoreCase(System.getProperty("remote.autologin", "true"))) {
            driver.findElement(By.name((String)"login_user")).clear();
            driver.findElement(By.name((String)"login_user")).sendKeys(new CharSequence[]{userName});
            driver.findElement(By.id((String)"Rice-LoginButton")).click();
            Thread.sleep(1000L);
            String contents = driver.getPageSource();
            AutomatedFunctionalTestUtils.failOnInvalidUserName(userName, contents, failable);
            AutomatedFunctionalTestUtils.checkForIncidentReport(driver.getPageSource(), "Login", "Login failure", failable);
        }
    }

    protected void logout() throws InterruptedException {
    }

    protected String multiValueResultCount() throws InterruptedException {
        WebElement dataTableInfo = this.waitAndGetElementByAttributeValue("class", "dataTables_info");
        String resultsCount = dataTableInfo.getText();
        resultsCount = resultsCount.substring(resultsCount.indexOf(" of ") + 4, resultsCount.indexOf(" entries")).trim();
        return resultsCount;
    }

    protected void open(String url) {
        this.driver.get(url);
    }

    @Override
    protected void navigate() throws Exception {
    }

    protected void screenshot() {
        try {
            this.webDriverScreenshotHelper.screenshot(this.driver, this.getClass().getSimpleName(), this.testName.getMethodName(), this.determinePage());
        }
        catch (Throwable t) {
            System.out.println("Problem with screenshot " + t.getMessage());
        }
    }

    protected void startSession(Method method) throws Exception {
        this.testMethodName = method.getName();
    }

    protected void select(By by, String selectText) throws InterruptedException {
        WebElement select1 = this.findElement(by);
        WebDriverUtils.highlightElement(this.driver, select1);
        String name = select1.getAttribute("name");
        this.jGrowl("Select " + selectText + " from " + name);
        List options = select1.findElements(By.tagName((String)"option"));
        for (WebElement option : options) {
            if (!option.getText().equals(selectText)) continue;
            option.click();
            break;
        }
    }

    protected void selectByXpath(String locator, String selectText) throws InterruptedException {
        this.select(By.xpath((String)locator), selectText);
    }

    protected void selectByName(String name, String selectText) throws InterruptedException {
        this.select(By.name((String)name), selectText);
    }

    protected void selectChildWindow() {
        this.selectWindow(this.driver.getWindowHandles().toArray()[1].toString());
    }

    protected void selectParentWindow() {
        this.selectWindow(this.driver.getWindowHandles().toArray()[0].toString());
    }

    protected void selectTopFrame() {
        this.driver.switchTo().defaultContent();
    }

    protected void selectWindow(String locator) {
        this.driver.switchTo().window(locator);
    }

    public void switchToWindow(String title) {
        Set windows = this.driver.getWindowHandles();
        for (String window : windows) {
            this.driver.switchTo().window(window);
            if (!this.driver.getTitle().contains(title)) continue;
            return;
        }
    }

    @After
    public void tearDown() {
        try {
            if (!this.isPassed()) {
                try {
                    System.out.println("Last AFT URL: " + this.driver.getCurrentUrl());
                }
                catch (Throwable t) {
                    System.out.println("Unable to determine LAST AFT URL due to " + t.getMessage());
                }
            }
            try {
                if (!this.isPassed() && this.webDriverScreenshotHelper.screenshotOnFailure() || this.webDriverScreenshotHelper.screenshotSteps()) {
                    this.screenshot();
                }
            }
            catch (Throwable t2) {
                System.out.println("Unable to take failure screenshot " + t2.getMessage());
            }
            try {
                if (this.isPassed() && WebDriverUtils.dontTearDownPropertyNotSet() && WebDriverUtils.dontTearDownOnFailure(this.isPassed())) {
                    this.logout();
                }
            }
            catch (Throwable t3) {
                System.out.println("Unable to logout " + t3.getMessage());
            }
            WebDriverUtils.tearDown(this.isPassed(), this.sessionId, this.toString().trim(), this.user, this.getClass().getSimpleName(), this.testName.getMethodName());
        }
        catch (Throwable t) {
            System.out.println("Exception in tearDown " + t.getMessage());
            t.printStackTrace();
        }
        finally {
            try {
                this.closeAndQuitWebDriver();
            }
            catch (Throwable t) {
                System.out.println(t.getMessage() + " occurred during tearDown, ignoring to avoid killing test run.");
                t.printStackTrace();
                System.out.println(t.getMessage() + " occurred during tearDown, ignoring to avoid killing test run.");
            }
        }
    }

    @Before
    public void testSetUp() {
        try {
            this.setUpSetUp();
            this.driver = WebDriverUtils.setUp(this.getClass().getSimpleName(), this.testMethodName);
            String testUrl = this.getTestUrl();
            if (!testUrl.startsWith("http")) {
                testUrl = this.getBaseUrlString() + testUrl;
            }
            WebDriverUtils.openTestUrl(this.driver, testUrl);
            this.sessionId = ((RemoteWebDriver)this.driver).getSessionId().toString();
            System.out.println(this.jGrowlHeader + " sessionId is " + this.sessionId);
            this.login(this.driver, this.getUserName(), this);
            this.navigateInternal();
            this.javascriptErrorsReport();
        }
        catch (Throwable t) {
            System.out.println("Throwable " + t.getMessage() + " in Before annotated method is very bad, ignoring and letting first method of test class to fail.");
            t.printStackTrace();
            System.out.println("Throwable " + t.getMessage() + " in Before annotated method is very bad, ignoring and letting first method of test class to fail.");
        }
    }

    public void setUpSetUp() {
        this.determineTestMethodName();
        this.determineImplicitWait();
        this.determineUser();
        this.determineJgrowlHeader();
    }

    protected void uncheck(By by) throws InterruptedException {
        WebElement element = this.findElement(by);
        if (element.isSelected()) {
            element.click();
        }
    }

    protected void uncheckByName(String name) throws InterruptedException {
        this.uncheck(By.name((String)name));
    }

    protected void uncheckByXpath(String locator) throws InterruptedException {
        this.uncheck(By.xpath((String)locator));
    }

    protected void waitAndClick(String locator) throws InterruptedException {
        this.waitAndClick(locator, this.getClass().toString());
    }

    protected void waitAndClick(By by) throws InterruptedException {
        this.jiraAwareWaitAndClick(by, this.getClass().toString());
    }

    protected void waitAndClick(By by, JiraAwareFailable failable) throws InterruptedException {
        this.jiraAwareWaitAndClick(by, this.getClass().toString(), failable);
    }

    protected void waitAndClick(String locator, String message) throws InterruptedException {
        this.jiraAwareWaitAndClick(By.cssSelector((String)locator), message);
    }

    protected void waitAndClickById(String id) throws InterruptedException {
        this.jiraAwareWaitAndClick(By.id((String)id), this.getClass().toString());
    }

    protected void waitAndClickById(String id, String message) throws InterruptedException {
        this.jiraAwareWaitAndClick(By.id((String)id), message);
    }

    protected void waitAndClickByLinkText(String text) throws InterruptedException {
        this.waitAndClickByLinkText(text, this.getClass().toString());
    }

    protected void waitAndClickByLinkText(String text, String message) throws InterruptedException {
        this.waitAndClickByLinkText(text, message, this);
    }

    protected void waitAndClickByLinkText(String text, JiraAwareFailable failable) throws InterruptedException {
        this.waitAndClickByLinkText(text, this.getClass().toString(), failable);
    }

    protected void waitAndClickByLinkText(String text, String message, JiraAwareFailable failable) throws InterruptedException {
        this.jGrowl("Click " + text + " link.");
        this.jiraAwareWaitAndClick(By.linkText((String)text), message, failable);
    }

    protected void waitAndClickLabeledLink(String label, String linkText) throws InterruptedException {
        this.jGrowl("Click link " + linkText + " labeled with " + label);
        this.waitAndClick(By.xpath((String)("//th/label[contains(text(), '" + label + "')]/../following-sibling::*/div/span/a[contains(text(), '" + linkText + "')]")));
    }

    protected void waitAndClickLabeledQuickFinder(String label) throws InterruptedException {
        this.jGrowl("Click link quickfinder labeled with " + label);
        this.waitAndClick(By.xpath((String)("//th/label[contains(text(), '" + label + "')]/../following-sibling::*/div/div/div/button[@class='btn btn-default uif-action icon-search']")));
        this.screenshot();
    }

    protected void waitAndTypeLabeledInput(String label, String text) throws InterruptedException {
        this.jGrowl("Type " + text + " in input labeled with " + label);
        this.waitAndTypeByXpath("//th/label[contains(text(), '" + label + "')]/../following-sibling::*//input", text);
        this.screenshot();
    }

    protected void waitAndSelectLabeled(String label, String text) throws InterruptedException {
        this.jGrowl("Select " + text + " labeled with " + label);
        this.waitAndSelectBy(By.xpath((String)("//th/label[contains(text(), '" + label + "')]/../following-sibling::*//select")), text);
        this.screenshot();
    }

    protected void waitAndClickLightBoxClose() throws InterruptedException {
        this.jGrowl("Click lightbox close");
        this.waitAndClickByXpath("//button[contains(text(),'x')]");
    }

    protected void waitAndClickLinkContainingText(String linkText) throws InterruptedException {
        this.waitAndClickLinkContainingText(linkText, this.getClass().toString());
    }

    protected void waitAndClickLinkContainingText(String linkText, String message) throws InterruptedException {
        this.jGrowl("Click link containing " + linkText + " .");
        this.waitAndClickByXpath("//a[contains(text(), '" + linkText + "')]", message);
    }

    protected void waitAndClickByName(String name) throws InterruptedException {
        this.jGrowl("Click By Name " + name);
        this.jiraAwareWaitAndClick(By.name((String)name), this.getClass().toString());
    }

    protected void waitAndClickByValue(String value) throws InterruptedException {
        this.waitAndGetElementByAttributeValue("value", value).click();
    }

    protected void waitAndClickByXpath(String xpath) throws InterruptedException {
        this.waitAndClick(By.xpath((String)xpath));
    }

    protected void waitAndClickByXpath(String xpath, JiraAwareFailable failable) throws InterruptedException {
        this.waitAndClick(By.xpath((String)xpath), failable);
    }

    protected void waitAndClickByName(String name, String message) throws InterruptedException {
        this.jiraAwareWaitAndClick(By.name((String)name), message);
    }

    protected void waitAndClickByXpath(String xpath, String message) throws InterruptedException {
        this.jiraAwareWaitAndClick(By.xpath((String)xpath), message);
    }

    protected void waitAndClickByXpath(String xpath, int waitSeconds, String message) throws InterruptedException {
        this.jiraAwareWaitAndClick(By.xpath((String)xpath), waitSeconds, message, this);
    }

    protected void waitAndClickButtonByText(String buttonText) throws InterruptedException {
        this.waitAndClickButtonByText(buttonText, this.getClass().toString());
    }

    protected void waitAndClickButtonByText(String buttonText, int waitSeconds) throws InterruptedException {
        this.waitAndClickButtonByText(buttonText, waitSeconds, this.getClass().toString());
    }

    protected void waitAndClickButtonByText(String buttonText, String message) throws InterruptedException {
        this.jGrowl("Click " + buttonText + " button.");
        this.waitAndClickByXpath("//button[contains(text(), '" + buttonText + "')]", message);
    }

    protected void waitAndClickButtonByText(String buttonText, int waitSeconds, String message) throws InterruptedException {
        this.jGrowl("Click " + buttonText + " button.");
        this.waitAndClickByXpath("//button[contains(text(), '" + buttonText + "')]", waitSeconds, message);
    }

    protected void waitAndClickButtonByExactText(String buttonText) throws InterruptedException {
        this.waitAndClickButtonByExactText(buttonText, this.getClass().toString());
    }

    protected void waitAndClickButtonByExactText(String buttonText, String message) throws InterruptedException {
        this.jGrowl("Click " + buttonText + " button.");
        this.waitAndClickByXpath("//button[normalize-space(.)='" + buttonText + "']", message);
    }

    protected void waitAndClickAllByName(String name) throws InterruptedException {
        List elements = this.driver.findElements(By.name((String)name));
        for (WebElement ele : elements) {
            ele.click();
        }
    }

    protected void waitAndClickConfirmCancelOk() throws InterruptedException {
        this.jGrowl("Click OK Confirmation");
        String xpath = "//div[@data-parent='ConfirmCancelDialog']/button[contains(text(),'OK')]";
        this.waitForElementVisibleBy(By.xpath((String)xpath)).click();
    }

    protected void waitAndClickConfirmBlanketApproveOk() throws InterruptedException {
        this.jGrowl("Click OK Confirmation");
        String xpath = "//div[@data-parent='ConfirmBlanketApproveDialog']/button[contains(text(),'OK')]";
        this.waitForElementVisibleBy(By.xpath((String)xpath)).click();
    }

    protected void waitAndClickConfirmDeleteYes() throws InterruptedException {
        this.jGrowl("Click Yes Confirmation");
        String xpath = "//section[@id='DialogGroup-DeleteFileUploadLine']//button[contains(text(),'Yes')]";
        this.waitForElementVisibleBy(By.xpath((String)xpath)).click();
    }

    protected void waitAndClickConfirmSaveOnClose() throws InterruptedException {
        this.jGrowl("Click OK Confirmation");
        this.waitForElementVisibleBy(By.xpath((String)"//div[@data-parent='ConfirmSaveOnCloseDialog']/button[contains(text(),'Yes')]"));
        this.waitAndClickByXpath("//div[@data-parent='ConfirmSaveOnCloseDialog']/button[contains(text(),'Yes')]");
    }

    protected void waitAndClickCancelSaveOnClose() throws InterruptedException {
        this.jGrowl("Click OK Confirmation");
        this.waitForElementVisibleBy(By.xpath((String)"//div[@data-parent='ConfirmSaveOnCloseDialog']/button[contains(text(),'No')]"));
        this.waitAndClickByXpath("//div[@data-parent='ConfirmSaveOnCloseDialog']/button[contains(text(),'No')]");
    }

    protected void waitAndClickConfirmSubmitOk() throws InterruptedException {
        this.jGrowl("Click OK Confirmation");
        String xpath = "//div[@data-parent='ConfirmSubmitDialog']/button[contains(text(),'OK')]";
        this.waitForElementVisibleBy(By.xpath((String)xpath)).click();
    }

    protected void waitAndClickDropDown(String dropDownText) throws InterruptedException {
        this.jGrowl("Click the " + dropDownText + " drop down.");
        WebElement dropdownMenu = this.waitAndGetElementByAttributeValue("class", "dropdown-toggle");
        Thread.sleep(1000L);
        dropdownMenu.click();
        this.waitAndClickByLinkText(dropDownText, "dropdown click " + dropDownText + " problem");
    }

    protected void waitAndClickReturnValue() throws InterruptedException {
        this.waitAndClickByLinkText(RETURN_VALUE_LINK_TEXT, "Unable to click return value " + this.getClass().toString());
    }

    protected void waitAndClickReturnValue(String message) throws InterruptedException {
        this.waitAndClickByLinkText(RETURN_VALUE_LINK_TEXT, message);
    }

    protected void waitAndClickSearch3() throws InterruptedException {
        this.jGrowl("Click Search");
        this.waitAndClickByXpath(SEARCH_XPATH_3);
    }

    protected String waitAndGetAttribute(By by, String attribute) throws InterruptedException {
        this.jiraAwareWaitFor(by, attribute);
        return this.findElement(by).getAttribute(attribute);
    }

    protected String waitAndGetAttributeByName(String name, String attribute) throws InterruptedException {
        return this.waitAndGetAttribute(By.name((String)name), attribute);
    }

    protected String waitAndGetAttributeByXpath(String locator, String attribute) throws InterruptedException {
        return this.waitAndGetAttribute(By.xpath((String)locator), attribute);
    }

    protected WebElement waitAndGetElementByAttributeValue(String attribute, String attributeValue) throws InterruptedException {
        return WebDriverUtils.waitAndGetElementByAttributeValue(this.driver, attribute, attributeValue, this.waitSeconds);
    }

    protected List<WebElement> waitAndGetElementsByAttributeValue(String attribute, String attributeValue) throws InterruptedException {
        this.driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
        boolean failed = false;
        int second = 0;
        while (true) {
            Thread.sleep(1000L);
            if (second >= this.waitSeconds) {
                failed = true;
            }
            try {
                if (failed || this.getElementsByAttributeValue(attribute, attributeValue) != null) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++second;
        }
        List<WebElement> elements = this.getElementsByAttributeValue(attribute, attributeValue);
        this.driver.manage().timeouts().implicitlyWait((long)WebDriverUtils.configuredImplicityWait(), TimeUnit.SECONDS);
        return elements;
    }

    protected String waitAndGetLabeledText(String label) throws InterruptedException {
        return this.waitForElementPresent(By.xpath((String)("//th/label[contains(text(), '" + label + "')]/../following-sibling::*/div/span"))).getText();
    }

    protected String[] waitAndGetText(By by) throws InterruptedException {
        WebDriverUtils.waitFors(this.driver, WebDriverUtils.configuredImplicityWait(), by, this.getClass().toString());
        List<WebElement> found = this.findElements(by);
        String[] texts = new String[found.size()];
        int i = 0;
        for (WebElement element : found) {
            texts[i++] = element.getText();
        }
        if (texts.length == 0) {
            this.jiraAwareFail(by.toString());
        }
        return texts;
    }

    protected void waitAndSelectBy(By by, String selectText) throws InterruptedException {
        this.waitFor(by, selectText + " not found.");
        this.select(by, selectText);
    }

    protected void waitAndSelectByName(String name, String selectText) throws InterruptedException {
        this.waitAndSelectBy(By.name((String)name), selectText);
    }

    protected WebElement waitAndType(By by, String text) throws InterruptedException {
        return this.waitAndType(by, text, this.getClass().toString());
    }

    protected WebElement waitAndType(String selector, String text) throws InterruptedException {
        return this.waitAndType(By.cssSelector((String)selector), text);
    }

    protected WebElement waitAndTypeById(String id, String text) throws InterruptedException {
        return this.waitAndType(By.id((String)id), text);
    }

    protected WebElement waitAndTypeByXpath(String locator, String text) throws InterruptedException {
        return this.waitAndType(By.xpath((String)locator), text);
    }

    protected WebElement waitAndTypeByXpath(String locator, String text, String message) throws InterruptedException {
        return this.waitAndType(By.xpath((String)locator), text, message);
    }

    protected WebElement waitAndTypeByName(String name, String text) throws InterruptedException {
        return this.waitAndType(By.name((String)name), text);
    }

    protected boolean waitAreAnyVisible(By[] bys) throws InterruptedException {
        if (bys == null || bys.length == 0) {
            return false;
        }
        for (int second = 0; second < this.waitSeconds; ++second) {
            if (this.isVisible(bys)) {
                return true;
            }
            Thread.sleep(1000L);
        }
        return false;
    }

    protected void waitForPageToLoad() throws InterruptedException {
        Thread.sleep(5000L);
        this.checkForIncidentReport();
    }

    protected WebElement waitFor(By by) throws InterruptedException {
        return this.jiraAwareWaitFor(by, this.getClass().toString());
    }

    protected void waitFor(By by, String message) throws InterruptedException {
        WebDriverUtils.waitFor(this.driver, this.waitSeconds, by, message);
    }

    protected WebElement waitForElementVisible(String elementLocator, String message) throws InterruptedException {
        return this.waitForElementVisibleBy(By.cssSelector((String)elementLocator), message);
    }

    protected WebElement waitForElementVisibleBy(By by) throws InterruptedException {
        return this.waitForElementVisibleBy(by, by.toString() + " NOT visible for class " + this.getClass().getSimpleName());
    }

    protected WebElement waitForElementVisibleBy(By by, String message) throws InterruptedException {
        this.driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
        boolean failed = false;
        int second = 0;
        while (true) {
            if (second >= this.waitSeconds) {
                failed = true;
            }
            try {
                if (failed || this.driver.findElement(by).isDisplayed()) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Thread.sleep(1000L);
            ++second;
        }
        this.checkForIncidentReport(by.toString());
        this.driver.manage().timeouts().implicitlyWait((long)this.waitSeconds, TimeUnit.SECONDS);
        if (failed) {
            this.jiraAwareFail("timeout of " + this.waitSeconds + " seconds waiting for " + by + " " + message + " " + this.driver.getCurrentUrl());
            return null;
        }
        return (WebElement)this.driver.findElements(by).get(0);
    }

    protected void waitForElementVisibleById(String id, String message) throws InterruptedException {
        this.waitForElementVisibleBy(By.id((String)id), message);
    }

    protected WebElement waitForElementPresent(By by) throws InterruptedException {
        return this.jiraAwareWaitFor(by, this.getClass().toString());
    }

    protected WebElement waitForElementPresent(By by, String message) throws InterruptedException {
        return this.jiraAwareWaitFor(by, message);
    }

    protected WebElement waitForElementPresent(String locator) throws InterruptedException {
        return this.jiraAwareWaitFor(By.cssSelector((String)locator), this.getClass().toString());
    }

    protected WebElement waitForElementPresentByClassName(String name) throws InterruptedException {
        return this.jiraAwareWaitFor(By.className((String)name), this.getClass().toString());
    }

    protected WebElement waitForElementPresentByClassName(String name, String message) throws InterruptedException {
        return this.jiraAwareWaitFor(By.className((String)name), message);
    }

    protected WebElement waitForElementPresentByClassName(String name, int seconds) throws InterruptedException {
        return this.jiraAwareWaitFor(By.className((String)name), seconds, this.getClass().toString());
    }

    protected void waitForElementsPresentByClassName(String name, String message) throws InterruptedException {
        this.jiraAwareWaitFors(By.className((String)name), message);
    }

    protected String waitForLabeledText(String label) throws InterruptedException {
        return this.waitForElementVisibleBy(By.xpath((String)("//th/label[contains(text(), '" + label + "')]/../following-sibling::*/div/span"))).getText();
    }

    protected List<WebElement> waitAndGetElementsFor(By by, String message) throws InterruptedException {
        try {
            return WebDriverUtils.waitFors(this.getDriver(), WebDriverUtils.configuredImplicityWait(), by, message);
        }
        catch (Throwable t) {
            this.jiraAwareFail(by, message, t);
            return new ArrayList<WebElement>();
        }
    }

    protected WebElement waitForElementPresentById(String id) throws InterruptedException {
        return this.jiraAwareWaitFor(By.id((String)id), this.getClass().toString());
    }

    protected void waitForElementPresentById(String id, String message) throws InterruptedException {
        this.jiraAwareWaitFor(By.id((String)id), message);
    }

    protected void waitForElementPresentById(String id, String message, int seconds) throws InterruptedException {
        this.jiraAwareWaitFor(By.id((String)id), seconds, message);
    }

    protected void waitForElementsPresentById(String id, String message) throws InterruptedException {
        this.jiraAwareWaitFors(By.id((String)id), message);
    }

    protected WebElement waitForElementPresentByName(String name) throws InterruptedException {
        return this.waitForElementPresentByName(name, this.getClass().toString());
    }

    protected WebElement waitForElementPresentByName(String name, String message) throws InterruptedException {
        return this.jiraAwareWaitFor(By.name((String)name), message);
    }

    protected WebElement waitForElementPresentByXpath(String xpath) throws InterruptedException {
        return this.jiraAwareWaitFor(By.xpath((String)xpath), this.getClass().toString());
    }

    protected WebElement waitForElementPresentByXpath(String xpath, String message) throws InterruptedException {
        return this.jiraAwareWaitFor(By.xpath((String)xpath), message);
    }

    protected void waitForElementsPresentByXpath(String xpathLocator) throws InterruptedException {
        this.jiraAwareWaitFors(By.xpath((String)xpathLocator), this.getClass().toString());
    }

    protected void waitForElementNotPresent(By by) throws InterruptedException {
        this.waitForElementNotPresent(by, WebDriverUtils.configuredImplicityWait());
    }

    protected void waitForElementNotPresent(By by, int secondsToWait) throws InterruptedException {
        this.waitForElementNotPresent(by, this.getClass().getSimpleName(), secondsToWait);
    }

    protected void waitForElementNotPresent(By by, String message) throws InterruptedException {
        this.waitForElementNotPresent(by, this.getClass().getSimpleName(), WebDriverUtils.configuredImplicityWait());
    }

    protected void waitForElementNotPresent(By by, String message, int secondsToWait) throws InterruptedException {
        this.driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
        while (this.isElementPresent(by) && secondsToWait != 0) {
            --secondsToWait;
            Thread.sleep(1000L);
        }
        if (this.isElementPresent(by)) {
            this.jiraAwareFail(by + " is still present " + message);
        }
        this.driver.manage().timeouts().implicitlyWait((long)this.waitSeconds, TimeUnit.SECONDS);
    }

    protected boolean waitForIsTextPresent(String text) throws InterruptedException {
        boolean present = false;
        this.driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
        for (int secondsToWait = WebDriverUtils.configuredImplicityWait(); !this.isTextPresent(text).booleanValue() && secondsToWait > 0; --secondsToWait) {
            Thread.sleep(1000L);
        }
        if (this.isTextPresent(text).booleanValue()) {
            present = true;
        }
        this.driver.manage().timeouts().implicitlyWait((long)this.waitSeconds, TimeUnit.SECONDS);
        return present;
    }

    protected void waitForProgress(String altText) throws InterruptedException {
        this.waitForProgress(altText, this.waitSeconds);
    }

    protected void waitForProgress(String altText, int timeout) throws InterruptedException {
        this.driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
        int second = 0;
        while (true) {
            Thread.sleep(1000L);
            if (second >= timeout) {
                this.jiraAwareFail("timeout still Loading after " + timeout + " seconds.");
            }
            try {
                if (!this.isElementPresentByXpath("//img[@alt='" + altText + "']")) break;
                if (!this.isVisible(By.xpath((String)("//img[@alt='" + altText + "']")))) {
                }
            }
            catch (Exception e) {}
            break;
            ++second;
        }
        this.driver.manage().timeouts().implicitlyWait((long)this.waitSeconds, TimeUnit.SECONDS);
    }

    protected void waitForProgressAddingLine() throws InterruptedException {
        this.waitForProgress("Adding Line...");
    }

    protected void waitForProgressDeletingLine() throws InterruptedException {
        this.waitForProgress("Deleting Line...");
    }

    protected void waitForProgressAddingLine(int secondsToWait) throws InterruptedException {
        this.waitForProgress("Adding Line...", secondsToWait);
    }

    protected void waitForProgressLoading() throws InterruptedException {
        this.waitForProgress("Loading...", WebDriverUtils.configuredImplicityWait() * 4);
    }

    protected void waitForProgressLoading(int secondsToWait) throws InterruptedException {
        this.waitForProgress("Loading...", secondsToWait);
    }

    protected void waitForProgressSaving() throws InterruptedException {
        this.waitForProgress("Saving...", WebDriverUtils.configuredImplicityWait() * 4);
    }

    protected void waitForProgressSaving(int secondsToWait) throws InterruptedException {
        this.waitForProgress("Saving...", secondsToWait);
    }

    protected void waitForTextPresent(String text) throws InterruptedException {
        this.waitForTextPresent(text, WebDriverUtils.configuredImplicityWait());
    }

    protected void waitForTextPresent(String text, String message) throws InterruptedException {
        this.waitForTextPresent(text, WebDriverUtils.configuredImplicityWait(), message);
    }

    protected void waitForTextPresent(String text, int secondsToWait) throws InterruptedException {
        this.waitForTextPresent(text, secondsToWait, this.getClass().getSimpleName());
    }

    protected void waitForTextPresent(String text, int secondsToWait, String message) throws InterruptedException {
        this.driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
        while (!this.isTextPresent(text).booleanValue() && secondsToWait > 0) {
            --secondsToWait;
            Thread.sleep(1000L);
        }
        if (!this.isTextPresent(text).booleanValue()) {
            this.jiraAwareFail(message + " " + text + " is not present for " + this.getClass().toString());
        }
        this.driver.manage().timeouts().implicitlyWait((long)this.waitSeconds, TimeUnit.SECONDS);
    }

    protected void waitForTextNotPresent(String text) throws InterruptedException {
        this.driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
        for (int secondsToWait = WebDriverUtils.configuredImplicityWait(); this.isTextPresent(text).booleanValue() && secondsToWait > 0; --secondsToWait) {
            Thread.sleep(1000L);
        }
        if (this.isTextPresent(text).booleanValue()) {
            this.jiraAwareFail(text + " is still present for " + this.getClass().toString());
        }
        this.driver.manage().timeouts().implicitlyWait((long)this.waitSeconds, TimeUnit.SECONDS);
    }

    protected void waitIsVisible(By by) throws InterruptedException {
        this.waitIsVisible(by, this.getClass().getSimpleName());
    }

    protected void waitIsVisible(By by, String message) throws InterruptedException {
        int second = 0;
        while (true) {
            if (second >= this.waitSeconds) {
                this.jiraAwareFail("timeout " + by.toString() + " " + message);
            }
            if (this.isVisible(by)) break;
            Thread.sleep(1000L);
            ++second;
        }
        if (!this.isVisible(by)) {
            this.jiraAwareFail(by.toString() + " not visiable", message);
        }
    }

    protected void waitIsVisible(String locator) throws InterruptedException {
        this.waitIsVisible(By.cssSelector((String)locator));
    }

    protected void waitIsVisibleByXpath(String locator) throws InterruptedException {
        this.waitIsVisible(By.xpath((String)locator));
    }

    protected void waitIsVisibleByXpath(String locator, String message) throws InterruptedException {
        this.waitIsVisible(By.xpath((String)locator), message);
    }

    protected void waitNotVisible(By by) throws InterruptedException {
        this.waitNotVisible(by, this.getClass().getSimpleName());
    }

    protected void waitNotVisible(By by, String message) throws InterruptedException {
        int second = 0;
        while (true) {
            if (second >= this.waitSeconds) {
                this.jiraAwareFail("timeout " + message);
            }
            if (!this.isVisible(by)) break;
            Thread.sleep(1000L);
            ++second;
        }
    }

    protected void waitNotVisibleByXpath(String locator) throws InterruptedException {
        this.waitNotVisible(By.xpath((String)locator));
    }

    protected void waitNotVisibleByXpath(String locator, String message) throws InterruptedException {
        this.waitNotVisible(By.xpath((String)locator), message);
    }
}

