/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.selenium;

import com.thoughtworks.selenium.SeleneseTestBase;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.kuali.rice.testtools.common.JiraAwareFailable;
import org.kuali.rice.testtools.selenium.AutomatedFunctionalTestUtils;
import org.kuali.rice.testtools.selenium.WebDriverUtils;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriverService;

public abstract class WebDriverITBase {
    public WebDriver driver;
    static ChromeDriverService chromeDriverService;

    public abstract String getTestUrl();

    public String getUserName() {
        return "admin";
    }

    @BeforeClass
    public static void createAndStartService() throws Exception {
        chromeDriverService = WebDriverUtils.chromeDriverCreateCheck();
        if (chromeDriverService != null) {
            chromeDriverService.start();
        }
    }

    public void login(WebDriver driver, String userName, JiraAwareFailable failable) throws InterruptedException {
        if ("true".equalsIgnoreCase(System.getProperty("remote.autologin", "true"))) {
            driver.findElement(By.name((String)"login_user")).clear();
            driver.findElement(By.name((String)"login_user")).sendKeys(new CharSequence[]{userName});
            driver.findElement(By.id((String)"Rice-LoginButton")).click();
            Thread.sleep(1000L);
            String contents = driver.getPageSource();
            AutomatedFunctionalTestUtils.failOnInvalidUserName(userName, contents, failable);
            AutomatedFunctionalTestUtils.checkForIncidentReport(driver.getPageSource(), "Login", "Login failure", failable);
        }
    }

    public void fail(String message) {
        SeleneseTestBase.fail((String)message);
    }

    @Before
    public void setUp() throws Exception {
        this.driver = WebDriverUtils.setUp(this.getClass().getSimpleName(), "DeprecatedWebDriverItBaseTest");
        WebDriverUtils.openTestUrl(this.driver, WebDriverUtils.getBaseUrlString() + "/" + this.getTestUrl());
        this.login(this.driver, this.getUserName(), new JiraAwareFailable(){

            @Override
            public void fail(String message) {
                SeleneseTestBase.fail((String)message);
            }

            @Override
            public void jiraAwareFail(String message) {
                SeleneseTestBase.fail((String)message);
            }

            @Override
            public void jiraAwareFail(String contents, String message) {
                SeleneseTestBase.fail((String)(contents + " " + message));
            }

            @Override
            public void jiraAwareFail(String contents, String message, Throwable throwable) {
                SeleneseTestBase.fail((String)(contents + " " + message + " " + throwable.getMessage()));
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        if (WebDriverUtils.dontTearDownPropertyNotSet()) {
            if (this.driver != null) {
                this.driver.quit();
            } else {
                System.out.println("WebDriver was null in WebDriverUtils.tearDown()");
            }
        }
    }

    @AfterClass
    public static void stopService() throws Exception {
        if (chromeDriverService != null) {
            chromeDriverService.stop();
        }
    }

    public boolean isElementPresent(By by) {
        return !this.driver.findElements(by).isEmpty();
    }

    public boolean isElementPresentQuick(By by) {
        this.driver.manage().timeouts().implicitlyWait((long)WebDriverUtils.IMPLICIT_WAIT_TIME_LOOP_MS, TimeUnit.MILLISECONDS);
        boolean result = this.isElementPresent(by);
        this.driver.manage().timeouts().implicitlyWait((long)WebDriverUtils.IMPLICIT_WAIT_TIME_SECONDS_DEFAULT, TimeUnit.SECONDS);
        return result;
    }

    public void assertPopUpWindowUrl(By by, String windowName, String url) {
        this.driver.findElement(by).click();
        String parentWindowHandle = this.driver.getWindowHandle();
        this.driver.switchTo().window(windowName).findElements(By.tagName((String)"head"));
        SeleneseTestBase.assertEquals((String)url, (String)this.driver.getCurrentUrl());
        this.driver.switchTo().window(parentWindowHandle);
    }

    protected void waitFor(By by) throws InterruptedException {
        this.waitFor(by, "");
    }

    protected void waitFor(By by, String message) throws InterruptedException {
        Thread.sleep(1000L);
        try {
            this.driver.findElement(by);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void waitAndType(By by, String text) throws InterruptedException {
        this.waitFor(by, "");
        try {
            this.driver.findElement(by).sendKeys(new CharSequence[]{text});
        }
        catch (Exception e) {
            this.fail(e.getMessage() + " " + by.toString() + " " + text);
            e.printStackTrace();
        }
    }

    protected void waitAndType(By by, String text, String message) throws InterruptedException {
        this.waitFor(by, "");
        try {
            this.driver.findElement(by).sendKeys(new CharSequence[]{text});
        }
        catch (Exception e) {
            this.fail(e.getMessage() + " " + by.toString() + " " + text + "  " + message);
            e.printStackTrace();
        }
    }

    protected void waitAndTypeByXpath(String locator, String text) throws InterruptedException {
        this.waitAndType(By.xpath((String)locator), text);
    }

    protected void waitAndTypeByXpath(String locator, String text, String message) throws InterruptedException {
        this.waitAndType(By.xpath((String)locator), text, message);
    }

    protected void waitAndTypeByName(String name, String text) throws InterruptedException {
        this.waitAndType(By.name((String)name), text);
    }

    protected void clearTextByName(String name) throws InterruptedException {
        this.clearText(By.name((String)name));
    }

    protected void clearTextByXpath(String locator) throws InterruptedException {
        this.clearText(By.xpath((String)locator));
    }

    protected void clearText(By by) throws InterruptedException {
        this.driver.findElement(by).clear();
    }

    protected void dismissAlert() {
        Alert alert = this.driver.switchTo().alert();
        alert.dismiss();
    }

    protected void acceptAlert() {
        Alert alert = this.driver.switchTo().alert();
        alert.accept();
    }

    protected String getEval(String script) {
        JavascriptExecutor js = (JavascriptExecutor)this.driver;
        return (String)js.executeScript(script, new Object[0]);
    }

    protected void switchWindow() {
        Set winSet = this.driver.getWindowHandles();
        ArrayList winList = new ArrayList(winSet);
        String newTab = (String)winList.get(winList.size() - 1);
        this.driver.switchTo().window(newTab);
    }

    protected String getAttributeByName(String name, String attribute) throws InterruptedException {
        return this.getAttribute(By.name((String)name), attribute);
    }

    protected String getAttributeByXpath(String locator, String attribute) throws InterruptedException {
        return this.getAttribute(By.xpath((String)locator), attribute);
    }

    protected String getAttribute(By by, String attribute) throws InterruptedException {
        return this.driver.findElement(by).getAttribute(attribute);
    }

    protected void waitAndClickByLinkText(String text) throws InterruptedException {
        this.waitAndClick(By.linkText((String)text), "");
    }

    protected void waitAndClickByLinkText(String text, String message) throws InterruptedException {
        this.waitAndClick(By.linkText((String)text), message);
    }

    protected void waitAndClick(By by) throws InterruptedException {
        this.waitAndClick(by, "");
    }

    protected void waitAndClick(By by, String message) throws InterruptedException {
        this.waitFor(by, message);
        try {
            this.driver.findElement(by).click();
        }
        catch (Exception e) {
            this.fail(e.getMessage() + " " + by.toString() + " " + message);
        }
    }

    protected void waitAndClick(String locator) throws InterruptedException {
        this.waitAndClick(locator, "");
    }

    protected void waitAndClick(String locator, String message) throws InterruptedException {
        this.waitAndClick(By.cssSelector((String)locator), message);
    }

    protected void waitForElementPresent(String locator) throws InterruptedException {
        this.waitFor(By.cssSelector((String)locator));
    }

    protected void waitForElementPresentByXpath(String locator) throws InterruptedException {
        this.waitFor(By.xpath((String)locator));
    }

    protected void waitForElementPresentByName(String name) throws InterruptedException {
        this.waitFor(By.name((String)name));
    }

    protected void checkForIncidentReport(JiraAwareFailable failable) {
        this.checkForIncidentReport("", failable, "");
    }

    protected void checkForIncidentReport(String locator, JiraAwareFailable failable) {
        this.checkForIncidentReport(locator, failable, "");
    }

    protected void checkForIncidentReport(String locator, JiraAwareFailable failable, String message) {
        AutomatedFunctionalTestUtils.checkForIncidentReport(this.driver.getPageSource(), locator, message, failable);
    }
}

