/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.common;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class PropertiesUtils {
    public Properties loadProperties(InputStream inputStream) throws IOException {
        Properties props = new Properties();
        if (inputStream != null) {
            props.load(inputStream);
        }
        return props;
    }

    @Deprecated
    public Properties loadProperties(String fileLocation, String resourceLocation) throws IOException {
        Properties props = null;
        InputStream in = null;
        if (fileLocation != null) {
            try {
                in = new FileInputStream(fileLocation);
            }
            catch (FileNotFoundException fio) {
                System.out.println(fio.getMessage() + " trying to read as resource.");
                if (resourceLocation != null) {
                    System.out.println("Trying to read as " + resourceLocation + " as a resource.");
                    in = this.getClass().getClassLoader().getResourceAsStream(resourceLocation);
                }
            }
        } else {
            in = this.getClass().getClassLoader().getResourceAsStream(resourceLocation);
            if (in == null) {
                System.out.println("Unable to read " + fileLocation + " as a file or " + resourceLocation + " as a resource stream");
            }
        }
        if (in != null) {
            props = this.loadProperties(in);
            in.close();
        }
        return props;
    }

    public Properties loadProperties(String location) throws IOException {
        InputStream in;
        Properties props;
        block3: {
            props = null;
            in = null;
            try {
                in = new FileInputStream(location);
            }
            catch (FileNotFoundException fio) {
                System.out.println(fio.getMessage() + " trying to read as resource.");
                in = this.getClass().getClassLoader().getResourceAsStream(location);
                if (in != null) break block3;
                System.out.println("Unable to read " + location + " as a resource stream");
            }
        }
        if (in != null) {
            props = this.loadProperties(in);
            ((InputStream)in).close();
        }
        return props;
    }

    public Properties loadPropertiesWithSystemAndOverrides(String location) throws IOException {
        Properties properties = this.loadProperties(location);
        return this.systemPropertiesAndOverride(properties);
    }

    public Properties loadPropertiesWithSystemAndOverridesIntoSystem(String location) throws IOException {
        Properties properties = this.loadProperties(location);
        properties = this.systemPropertiesAndOverride(properties);
        for (String string : properties.keySet()) {
            if (System.getProperty(string) != null) continue;
            System.setProperty(string, properties.getProperty(string));
        }
        return properties;
    }

    public Properties loadPropertiesWithSystemOverrides(String location) throws IOException {
        Properties properties = this.loadProperties(location);
        return this.systemPropertiesOverride(properties);
    }

    public Properties loadPropertiesWithSystemOverrides(InputStream inputStream) throws IOException {
        Properties props = this.loadProperties(inputStream);
        props = this.systemPropertiesOverride(props);
        return props;
    }

    public Properties loadPropertiesWithSystemOverridesAndNumberedPropertiesToList(InputStream inputStream) throws IOException {
        Properties props = this.loadProperties(inputStream);
        props = this.systemPropertiesOverride(props);
        props = this.transformNumberedPropertiesToList(props);
        return props;
    }

    public String removeNumber(String numberedKey) {
        String unnumberedKey = numberedKey;
        int firstNumberIndex = unnumberedKey.length() - 1;
        while (Character.isDigit(unnumberedKey.charAt(firstNumberIndex))) {
            --firstNumberIndex;
        }
        unnumberedKey = unnumberedKey.substring(0, firstNumberIndex + 1);
        return unnumberedKey;
    }

    public Properties systemPropertiesAndOverride(Properties props) {
        return this.systemPropertiesAndOverride(props, null);
    }

    public Properties systemPropertiesOverride(Properties props) {
        return this.systemPropertiesOverride(props, null);
    }

    public Properties systemPropertiesAndOverride(Properties props, String arg) {
        PropertiesUtils propUtils = new PropertiesUtils();
        props = propUtils.systemPropertiesOverride(props, arg);
        for (String key : System.getProperties().stringPropertyNames()) {
            if (arg == null || arg.equals("")) {
                if (props.containsValue(key)) continue;
                props.setProperty(key, System.getProperty(key));
                continue;
            }
            if (!key.startsWith(arg) || props.containsValue(key)) continue;
            props.setProperty(key, System.getProperty(key));
        }
        return props;
    }

    public Properties systemPropertiesOverride(Properties props, String arg) {
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            Object nameObject = names.nextElement();
            if (!(nameObject instanceof String)) continue;
            String key = (String)nameObject;
            if (arg == null || arg.isEmpty()) {
                props.setProperty(key, System.getProperty(key, props.getProperty(key)));
                continue;
            }
            props.setProperty(key, System.getProperty(arg + "." + key, props.getProperty(key)));
        }
        return props;
    }

    public Properties transformNumberedPropertiesToList(Properties props) {
        String key2 = null;
        String unnumberedKey = null;
        List<String> keyList = null;
        LinkedList<String> removeKeys = new LinkedList<String>();
        Iterator<Object> keys = props.keySet().iterator();
        HashMap keysLists = new HashMap();
        while (keys.hasNext()) {
            key2 = (String)keys.next();
            if (!Character.isDigit(key2.charAt(key2.length() - 1))) continue;
            unnumberedKey = this.removeNumber(key2);
            if (keysLists.get(unnumberedKey) == null) {
                keyList = new ArrayList<String>();
                keyList.add(props.getProperty(key2));
                keysLists.put(unnumberedKey, keyList);
                removeKeys.add(key2);
                continue;
            }
            keyList = (List)keysLists.get(unnumberedKey);
            keyList.add(props.getProperty(key2));
            keysLists.put(unnumberedKey, keyList);
            removeKeys.add(key2);
        }
        for (String key2 : removeKeys) {
            props.remove(key2);
        }
        Iterator newKeys = keysLists.keySet().iterator();
        String newKey = null;
        while (newKeys.hasNext()) {
            newKey = (String)newKeys.next();
            props.put(newKey + "s", keysLists.get(newKey));
        }
        return props;
    }
}

