/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.selenium.breadcrumb;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Test;
import org.kuali.rice.testtools.selenium.WebDriverLegacyITBase;
import org.openqa.selenium.By;

public abstract class BreadcrumbAftBase
extends WebDriverLegacyITBase {
    public static final String SECOND_BREADCRUMB_NAV_XPATH = "//div[@class='uif-breadcrumbSiblingContent']//div[@class='uif-inputField']//ul[@class='uif-optionList']";
    public static final String SECOND_DOWN_TRIANGLE_XPATH = "(//a[@class='uif-breadcrumbSiblingLink'])[2]";
    String[][] selectAsserts = new String[][]{{"UifCompView", "Uif Components"}};
    int[] breadcrumbOrderIndexes = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 1};

    protected String getTriangleXpath() {
        return SECOND_DOWN_TRIANGLE_XPATH;
    }

    protected void testBreadcrumb(int pageNumber) throws Exception {
        this.jiraAwareWaitFor(By.xpath((String)SECOND_BREADCRUMB_NAV_XPATH));
        this.assertFalse(this.isVisibleByXpath(SECOND_BREADCRUMB_NAV_XPATH));
        this.waitAndClickByXpath(this.getTriangleXpath(), "failed on breadcrumb pageNumber " + pageNumber);
        Thread.sleep(100L);
        this.assertTrue(this.isVisibleByXpath(SECOND_BREADCRUMB_NAV_XPATH));
        this.waitAndClickByXpath(this.getTriangleXpath());
        this.assertFalse(this.isVisibleByXpath(SECOND_BREADCRUMB_NAV_XPATH));
        this.waitAndClickByXpath(this.getTriangleXpath());
        this.waitAndClickByXpath("//div[@class='uif-breadcrumbSiblingContent']//div[@class='uif-inputField']//ul[@class='uif-optionList']/li[" + pageNumber + "]/a");
        this.waitForElementPresentById("TopLink" + pageNumber, "Breadcrumb number " + pageNumber + " failure", 30);
        this.driver.getCurrentUrl().contains("pageId=UifCompView-Page" + pageNumber);
    }

    protected void testBreadcrumbs() throws Exception {
        int s = this.breadcrumbOrderIndexes.length;
        for (int i = 0; i < s; ++i) {
            this.testBreadcrumb(this.breadcrumbOrderIndexes[i]);
        }
    }

    protected void testBreadcrumbsShuffled() throws Exception {
        int[] copiedBreadcrumbOrderIndex = Arrays.copyOf(this.breadcrumbOrderIndexes, this.breadcrumbOrderIndexes.length);
        Collections.shuffle(Ints.asList((int[])copiedBreadcrumbOrderIndex));
        int s = copiedBreadcrumbOrderIndex.length;
        for (int i = 0; i < s; ++i) {
            this.jGrowl("Click on Bread crumb index number " + i);
            this.testBreadcrumb(copiedBreadcrumbOrderIndex[i]);
        }
    }

    @Test
    public void testBreadcrumbBookmark() throws Exception {
        this.testBreadcrumbs();
        this.passed();
    }

    @Test
    public void testBreadcrumbShuffledBookmark() throws Exception {
        this.testBreadcrumbsShuffled();
        this.passed();
    }

    @Test
    public void testBreadcrumbNav() throws Exception {
        this.testBreadcrumbs();
        this.passed();
    }

    @Test
    public void testBreadcrumbShuffledNav() throws Exception {
        this.testBreadcrumbsShuffled();
        this.passed();
    }
}

