/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.common;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.kuali.rice.testtools.common.JiraAwareFailureUtils;

public class JiraAwareStatusCheck {
    public static void main(String[] args) {
        String baseUrl = "https://jira.kuali.org/browse/";
        String jira = "";
        String statusSpan = "<span id=\"status-val\" class=\"value\">";
        JiraAwareStatusCheck.checkJiraMatchesContains(baseUrl, jira, statusSpan);
        JiraAwareStatusCheck.checkJiraMatchesRegex(baseUrl, jira, statusSpan);
    }

    private static void checkJiraMatchesContains(String baseUrl, String jira, String statusSpan) {
        for (String string : JiraAwareFailureUtils.jiraMatches.keySet()) {
            jira = JiraAwareFailureUtils.jiraMatches.getProperty(string);
            jira = jira.substring(0, jira.indexOf(" "));
            try {
                String status = JiraAwareStatusCheck.getStatus(baseUrl, jira, statusSpan);
                System.out.println(jira + " Status: " + status + " for key: " + string);
            }
            catch (Exception e) {
                System.out.println("Exception reading " + baseUrl + jira + " " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static void checkJiraMatchesRegex(String baseUrl, String jira, String statusSpan) {
        for (String string : JiraAwareFailureUtils.regexJiraMatches.keySet()) {
            jira = JiraAwareFailureUtils.regexJiraMatches.getProperty(string);
            jira = jira.substring(0, jira.indexOf(" "));
            try {
                String status = JiraAwareStatusCheck.getStatus(baseUrl, jira, statusSpan);
                System.out.println(jira + " Status: " + status + " for key: " + string);
            }
            catch (Exception e) {
                System.out.println("Exception reading " + baseUrl + jira + " " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static String getStatus(String baseUrl, String jira, String statusSpan) throws Exception {
        String contents = JiraAwareStatusCheck.getText(baseUrl + jira);
        contents = contents.substring(contents.indexOf(statusSpan) + statusSpan.length(), contents.length());
        contents = contents.substring(0, contents.indexOf("</span>"));
        String status = contents.substring(contents.indexOf("alt=\"") + 5, contents.length());
        status = status.substring(0, status.indexOf("\""));
        return status;
    }

    public static String getText(String url) throws Exception {
        String inputLine;
        URL website = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)website.openConnection();
        connection.setInstanceFollowRedirects(true);
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }
}

